/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ParticipantTokenCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateParticipantResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreateParticipantResponse> {
    private static final SdkField<ParticipantTokenCredentials> PARTICIPANT_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipantCredentials").getter(CreateParticipantResponse.getter(CreateParticipantResponse::participantCredentials)).setter(CreateParticipantResponse.setter(Builder::participantCredentials)).constructor(ParticipantTokenCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantCredentials").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(CreateParticipantResponse.getter(CreateParticipantResponse::participantId)).setter(CreateParticipantResponse.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_CREDENTIALS_FIELD, PARTICIPANT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ParticipantCredentials", PARTICIPANT_CREDENTIALS_FIELD);
            this.put("ParticipantId", PARTICIPANT_ID_FIELD);
        }
    });
    private final ParticipantTokenCredentials participantCredentials;
    private final String participantId;

    private CreateParticipantResponse(BuilderImpl builder) {
        super(builder);
        this.participantCredentials = builder.participantCredentials;
        this.participantId = builder.participantId;
    }

    public final ParticipantTokenCredentials participantCredentials() {
        return this.participantCredentials;
    }

    public final String participantId() {
        return this.participantId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.participantCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantResponse)) {
            return false;
        }
        CreateParticipantResponse other = (CreateParticipantResponse)((Object)obj);
        return Objects.equals(this.participantCredentials(), other.participantCredentials()) && Objects.equals(this.participantId(), other.participantId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateParticipantResponse").add("ParticipantCredentials", (Object)this.participantCredentials()).add("ParticipantId", (Object)this.participantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParticipantCredentials": {
                return Optional.ofNullable(clazz.cast(this.participantCredentials()));
            }
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantResponse, T> g) {
        return obj -> g.apply((CreateParticipantResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private ParticipantTokenCredentials participantCredentials;
        private String participantId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantResponse model) {
            super(model);
            this.participantCredentials(model.participantCredentials);
            this.participantId(model.participantId);
        }

        public final ParticipantTokenCredentials.Builder getParticipantCredentials() {
            return this.participantCredentials != null ? this.participantCredentials.toBuilder() : null;
        }

        public final void setParticipantCredentials(ParticipantTokenCredentials.BuilderImpl participantCredentials) {
            this.participantCredentials = participantCredentials != null ? participantCredentials.build() : null;
        }

        @Override
        public final Builder participantCredentials(ParticipantTokenCredentials participantCredentials) {
            this.participantCredentials = participantCredentials;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        @Override
        public CreateParticipantResponse build() {
            return new CreateParticipantResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateParticipantResponse> {
        public Builder participantCredentials(ParticipantTokenCredentials var1);

        default public Builder participantCredentials(Consumer<ParticipantTokenCredentials.Builder> participantCredentials) {
            return this.participantCredentials((ParticipantTokenCredentials)((ParticipantTokenCredentials.Builder)ParticipantTokenCredentials.builder().applyMutation(participantCredentials)).build());
        }

        public Builder participantId(String var1);
    }
}

