/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQueueResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreateQueueResponse> {
    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueArn").getter(CreateQueueResponse.getter(CreateQueueResponse::queueArn)).setter(CreateQueueResponse.setter(Builder::queueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(CreateQueueResponse.getter(CreateQueueResponse::queueId)).setter(CreateQueueResponse.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ARN_FIELD, QUEUE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("QueueArn", QUEUE_ARN_FIELD);
            this.put("QueueId", QUEUE_ID_FIELD);
        }
    });
    private final String queueArn;
    private final String queueId;

    private CreateQueueResponse(BuilderImpl builder) {
        super(builder);
        this.queueArn = builder.queueArn;
        this.queueId = builder.queueId;
    }

    public final String queueArn() {
        return this.queueArn;
    }

    public final String queueId() {
        return this.queueId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueResponse)) {
            return false;
        }
        CreateQueueResponse other = (CreateQueueResponse)((Object)obj);
        return Objects.equals(this.queueArn(), other.queueArn()) && Objects.equals(this.queueId(), other.queueId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQueueResponse").add("QueueArn", (Object)this.queueArn()).add("QueueId", (Object)this.queueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueArn": {
                return Optional.ofNullable(clazz.cast(this.queueArn()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueResponse, T> g) {
        return obj -> g.apply((CreateQueueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String queueArn;
        private String queueId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueResponse model) {
            super(model);
            this.queueArn(model.queueArn);
            this.queueId(model.queueId);
        }

        public final String getQueueArn() {
            return this.queueArn;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public CreateQueueResponse build() {
            return new CreateQueueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQueueResponse> {
        public Builder queueArn(String var1);

        public Builder queueId(String var1);
    }
}

