/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.AuthenticationProfileSummary;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesResponse;

public class ListAuthenticationProfilesIterable
implements SdkIterable<ListAuthenticationProfilesResponse> {
    private final ConnectClient client;
    private final ListAuthenticationProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAuthenticationProfilesIterable(ConnectClient client, ListAuthenticationProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAuthenticationProfilesResponseFetcher();
    }

    public Iterator<ListAuthenticationProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuthenticationProfileSummary> authenticationProfileSummaryList() {
        Function<ListAuthenticationProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.authenticationProfileSummaryList() != null) {
                return response.authenticationProfileSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAuthenticationProfilesResponseFetcher
    implements SyncPageFetcher<ListAuthenticationProfilesResponse> {
        private ListAuthenticationProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListAuthenticationProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAuthenticationProfilesResponse nextPage(ListAuthenticationProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListAuthenticationProfilesIterable.this.client.listAuthenticationProfiles(ListAuthenticationProfilesIterable.this.firstRequest);
            }
            return ListAuthenticationProfilesIterable.this.client.listAuthenticationProfiles((ListAuthenticationProfilesRequest)((Object)ListAuthenticationProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

