/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.services.connect.model.TaskTemplateConstraints;
import software.amazon.awssdk.services.connect.model.TaskTemplateDefaults;
import software.amazon.awssdk.services.connect.model.TaskTemplateField;
import software.amazon.awssdk.services.connect.model.TaskTemplateFieldsCopier;
import software.amazon.awssdk.services.connect.model.TaskTemplateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTaskTemplateResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetTaskTemplateResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::instanceId)).setter(GetTaskTemplateResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::id)).setter(GetTaskTemplateResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::arn)).setter(GetTaskTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::name)).setter(GetTaskTemplateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::description)).setter(GetTaskTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::contactFlowId)).setter(GetTaskTemplateResponse.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<TaskTemplateConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constraints").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::constraints)).setter(GetTaskTemplateResponse.setter(Builder::constraints)).constructor(TaskTemplateConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final SdkField<TaskTemplateDefaults> DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Defaults").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::defaults)).setter(GetTaskTemplateResponse.setter(Builder::defaults)).constructor(TaskTemplateDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Defaults").build()}).build();
    private static final SdkField<List<TaskTemplateField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::fields)).setter(GetTaskTemplateResponse.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskTemplateField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::statusAsString)).setter(GetTaskTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::lastModifiedTime)).setter(GetTaskTemplateResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::createdTime)).setter(GetTaskTemplateResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetTaskTemplateResponse.getter(GetTaskTemplateResponse::tags)).setter(GetTaskTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONTACT_FLOW_ID_FIELD, CONSTRAINTS_FIELD, DEFAULTS_FIELD, FIELDS_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATED_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
            this.put("Constraints", CONSTRAINTS_FIELD);
            this.put("Defaults", DEFAULTS_FIELD);
            this.put("Fields", FIELDS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String instanceId;
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final String contactFlowId;
    private final TaskTemplateConstraints constraints;
    private final TaskTemplateDefaults defaults;
    private final List<TaskTemplateField> fields;
    private final String status;
    private final Instant lastModifiedTime;
    private final Instant createdTime;
    private final Map<String, String> tags;

    private GetTaskTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.contactFlowId = builder.contactFlowId;
        this.constraints = builder.constraints;
        this.defaults = builder.defaults;
        this.fields = builder.fields;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdTime = builder.createdTime;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final TaskTemplateConstraints constraints() {
        return this.constraints;
    }

    public final TaskTemplateDefaults defaults() {
        return this.defaults;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<TaskTemplateField> fields() {
        return this.fields;
    }

    public final TaskTemplateStatus status() {
        return TaskTemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskTemplateResponse)) {
            return false;
        }
        GetTaskTemplateResponse other = (GetTaskTemplateResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.constraints(), other.constraints()) && Objects.equals(this.defaults(), other.defaults()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetTaskTemplateResponse").add("InstanceId", (Object)this.instanceId()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ContactFlowId", (Object)this.contactFlowId()).add("Constraints", (Object)this.constraints()).add("Defaults", (Object)this.defaults()).add("Fields", this.hasFields() ? this.fields() : null).add("Status", (Object)this.statusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreatedTime", (Object)this.createdTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "Defaults": {
                return Optional.ofNullable(clazz.cast(this.defaults()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTaskTemplateResponse, T> g) {
        return obj -> g.apply((GetTaskTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String instanceId;
        private String id;
        private String arn;
        private String name;
        private String description;
        private String contactFlowId;
        private TaskTemplateConstraints constraints;
        private TaskTemplateDefaults defaults;
        private List<TaskTemplateField> fields = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant lastModifiedTime;
        private Instant createdTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskTemplateResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.contactFlowId(model.contactFlowId);
            this.constraints(model.constraints);
            this.defaults(model.defaults);
            this.fields(model.fields);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.createdTime(model.createdTime);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final TaskTemplateConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(TaskTemplateConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(TaskTemplateConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final TaskTemplateDefaults.Builder getDefaults() {
            return this.defaults != null ? this.defaults.toBuilder() : null;
        }

        public final void setDefaults(TaskTemplateDefaults.BuilderImpl defaults) {
            this.defaults = defaults != null ? defaults.build() : null;
        }

        @Override
        public final Builder defaults(TaskTemplateDefaults defaults) {
            this.defaults = defaults;
            return this;
        }

        public final List<TaskTemplateField.Builder> getFields() {
            List<TaskTemplateField.Builder> result = TaskTemplateFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<TaskTemplateField.BuilderImpl> fields) {
            this.fields = TaskTemplateFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<TaskTemplateField> fields) {
            this.fields = TaskTemplateFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(TaskTemplateField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<TaskTemplateField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (TaskTemplateField)((TaskTemplateField.Builder)TaskTemplateField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTaskTemplateResponse build() {
            return new GetTaskTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTaskTemplateResponse> {
        public Builder instanceId(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder contactFlowId(String var1);

        public Builder constraints(TaskTemplateConstraints var1);

        default public Builder constraints(Consumer<TaskTemplateConstraints.Builder> constraints) {
            return this.constraints((TaskTemplateConstraints)((TaskTemplateConstraints.Builder)TaskTemplateConstraints.builder().applyMutation(constraints)).build());
        }

        public Builder defaults(TaskTemplateDefaults var1);

        default public Builder defaults(Consumer<TaskTemplateDefaults.Builder> defaults) {
            return this.defaults((TaskTemplateDefaults)((TaskTemplateDefaults.Builder)TaskTemplateDefaults.builder().applyMutation(defaults)).build());
        }

        public Builder fields(Collection<TaskTemplateField> var1);

        public Builder fields(TaskTemplateField ... var1);

        public Builder fields(Consumer<TaskTemplateField.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TaskTemplateStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder createdTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

