/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlow;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsResponse;

public class SearchContactFlowsIterable
implements SdkIterable<SearchContactFlowsResponse> {
    private final ConnectClient client;
    private final SearchContactFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchContactFlowsIterable(ConnectClient client, SearchContactFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchContactFlowsResponseFetcher();
    }

    public Iterator<SearchContactFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlow> contactFlows() {
        Function<SearchContactFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlows() != null) {
                return response.contactFlows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchContactFlowsResponseFetcher
    implements SyncPageFetcher<SearchContactFlowsResponse> {
        private SearchContactFlowsResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchContactFlowsResponse nextPage(SearchContactFlowsResponse previousPage) {
            if (previousPage == null) {
                return SearchContactFlowsIterable.this.client.searchContactFlows(SearchContactFlowsIterable.this.firstRequest);
            }
            return SearchContactFlowsIterable.this.client.searchContactFlows((SearchContactFlowsRequest)((Object)SearchContactFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

