/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VocabularyLanguageCode {
    AR_AE("ar-AE"),
    DE_CH("de-CH"),
    DE_DE("de-DE"),
    EN_AB("en-AB"),
    EN_AU("en-AU"),
    EN_GB("en-GB"),
    EN_IE("en-IE"),
    EN_IN("en-IN"),
    EN_US("en-US"),
    EN_WL("en-WL"),
    ES_ES("es-ES"),
    ES_US("es-US"),
    FR_CA("fr-CA"),
    FR_FR("fr-FR"),
    HI_IN("hi-IN"),
    IT_IT("it-IT"),
    JA_JP("ja-JP"),
    KO_KR("ko-KR"),
    PT_BR("pt-BR"),
    PT_PT("pt-PT"),
    ZH_CN("zh-CN"),
    EN_NZ("en-NZ"),
    EN_ZA("en-ZA"),
    CA_ES("ca-ES"),
    DA_DK("da-DK"),
    FI_FI("fi-FI"),
    ID_ID("id-ID"),
    MS_MY("ms-MY"),
    NL_NL("nl-NL"),
    NO_NO("no-NO"),
    PL_PL("pl-PL"),
    SV_SE("sv-SE"),
    TL_PH("tl-PH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VocabularyLanguageCode> VALUE_MAP;
    private final String value;

    private VocabularyLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VocabularyLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VocabularyLanguageCode> knownValues() {
        EnumSet<VocabularyLanguageCode> knownValues = EnumSet.allOf(VocabularyLanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VocabularyLanguageCode.class, VocabularyLanguageCode::toString);
    }
}

