/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.InstanceReplicationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationStatusSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationStatusSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ReplicationStatusSummary.getter(ReplicationStatusSummary::region)).setter(ReplicationStatusSummary.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationStatus").getter(ReplicationStatusSummary.getter(ReplicationStatusSummary::replicationStatusAsString)).setter(ReplicationStatusSummary.setter(Builder::replicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatus").build()}).build();
    private static final SdkField<String> REPLICATION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationStatusReason").getter(ReplicationStatusSummary.getter(ReplicationStatusSummary::replicationStatusReason)).setter(ReplicationStatusSummary.setter(Builder::replicationStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, REPLICATION_STATUS_FIELD, REPLICATION_STATUS_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String replicationStatus;
    private final String replicationStatusReason;

    private ReplicationStatusSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusReason = builder.replicationStatusReason;
    }

    public final String region() {
        return this.region;
    }

    public final InstanceReplicationStatus replicationStatus() {
        return InstanceReplicationStatus.fromValue(this.replicationStatus);
    }

    public final String replicationStatusAsString() {
        return this.replicationStatus;
    }

    public final String replicationStatusReason() {
        return this.replicationStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationStatusSummary)) {
            return false;
        }
        ReplicationStatusSummary other = (ReplicationStatusSummary)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.replicationStatusAsString(), other.replicationStatusAsString()) && Objects.equals(this.replicationStatusReason(), other.replicationStatusReason());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationStatusSummary").add("Region", (Object)this.region()).add("ReplicationStatus", (Object)this.replicationStatusAsString()).add("ReplicationStatusReason", (Object)this.replicationStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ReplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusAsString()));
            }
            case "ReplicationStatusReason": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationStatusSummary, T> g) {
        return obj -> g.apply((ReplicationStatusSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String replicationStatus;
        private String replicationStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationStatusSummary model) {
            this.region(model.region);
            this.replicationStatus(model.replicationStatus);
            this.replicationStatusReason(model.replicationStatusReason);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getReplicationStatus() {
            return this.replicationStatus;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(InstanceReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final String getReplicationStatusReason() {
            return this.replicationStatusReason;
        }

        public final void setReplicationStatusReason(String replicationStatusReason) {
            this.replicationStatusReason = replicationStatusReason;
        }

        @Override
        public final Builder replicationStatusReason(String replicationStatusReason) {
            this.replicationStatusReason = replicationStatusReason;
            return this;
        }

        public ReplicationStatusSummary build() {
            return new ReplicationStatusSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationStatusSummary> {
        public Builder region(String var1);

        public Builder replicationStatus(String var1);

        public Builder replicationStatus(InstanceReplicationStatus var1);

        public Builder replicationStatusReason(String var1);
    }
}

