/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse;

public class ListSecurityProfilePermissionsIterable
implements SdkIterable<ListSecurityProfilePermissionsResponse> {
    private final ConnectClient client;
    private final ListSecurityProfilePermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityProfilePermissionsIterable(ConnectClient client, ListSecurityProfilePermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityProfilePermissionsResponseFetcher();
    }

    public Iterator<ListSecurityProfilePermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> permissions() {
        Function<ListSecurityProfilePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityProfilePermissionsResponseFetcher
    implements SyncPageFetcher<ListSecurityProfilePermissionsResponse> {
        private ListSecurityProfilePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfilePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityProfilePermissionsResponse nextPage(ListSecurityProfilePermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfilePermissionsIterable.this.client.listSecurityProfilePermissions(ListSecurityProfilePermissionsIterable.this.firstRequest);
            }
            return ListSecurityProfilePermissionsIterable.this.client.listSecurityProfilePermissions((ListSecurityProfilePermissionsRequest)((Object)ListSecurityProfilePermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

