/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse;

public class ListIntegrationAssociationsIterable
implements SdkIterable<ListIntegrationAssociationsResponse> {
    private final ConnectClient client;
    private final ListIntegrationAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIntegrationAssociationsIterable(ConnectClient client, ListIntegrationAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIntegrationAssociationsResponseFetcher();
    }

    public Iterator<ListIntegrationAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IntegrationAssociationSummary> integrationAssociationSummaryList() {
        Function<ListIntegrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrationAssociationSummaryList() != null) {
                return response.integrationAssociationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIntegrationAssociationsResponseFetcher
    implements SyncPageFetcher<ListIntegrationAssociationsResponse> {
        private ListIntegrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntegrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIntegrationAssociationsResponse nextPage(ListIntegrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListIntegrationAssociationsIterable.this.client.listIntegrationAssociations(ListIntegrationAssociationsIterable.this.firstRequest);
            }
            return ListIntegrationAssociationsIterable.this.client.listIntegrationAssociations((ListIntegrationAssociationsRequest)((Object)ListIntegrationAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

