/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.UserIdListCopier;
import software.amazon.awssdk.services.connect.model.UserTagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationRecipientType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationRecipientType> {
    private static final SdkField<Map<String, String>> USER_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserTags").getter(NotificationRecipientType.getter(NotificationRecipientType::userTags)).setter(NotificationRecipientType.setter(Builder::userTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIds").getter(NotificationRecipientType.getter(NotificationRecipientType::userIds)).setter(NotificationRecipientType.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_TAGS_FIELD, USER_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> userTags;
    private final List<String> userIds;

    private NotificationRecipientType(BuilderImpl builder) {
        this.userTags = builder.userTags;
        this.userIds = builder.userIds;
    }

    public final boolean hasUserTags() {
        return this.userTags != null && !(this.userTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userTags() {
        return this.userTags;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserTags() ? this.userTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationRecipientType)) {
            return false;
        }
        NotificationRecipientType other = (NotificationRecipientType)obj;
        return this.hasUserTags() == other.hasUserTags() && Objects.equals(this.userTags(), other.userTags()) && this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationRecipientType").add("UserTags", this.hasUserTags() ? this.userTags() : null).add("UserIds", this.hasUserIds() ? this.userIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserTags": {
                return Optional.ofNullable(clazz.cast(this.userTags()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationRecipientType, T> g) {
        return obj -> g.apply((NotificationRecipientType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> userTags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationRecipientType model) {
            this.userTags(model.userTags);
            this.userIds(model.userIds);
        }

        public final Map<String, String> getUserTags() {
            if (this.userTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userTags;
        }

        public final void setUserTags(Map<String, String> userTags) {
            this.userTags = UserTagMapCopier.copy(userTags);
        }

        @Override
        public final Builder userTags(Map<String, String> userTags) {
            this.userTags = UserTagMapCopier.copy(userTags);
            return this;
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public NotificationRecipientType build() {
            return new NotificationRecipientType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationRecipientType> {
        public Builder userTags(Map<String, String> var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);
    }
}

