/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.InstanceAttributeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInstanceAttributeRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateInstanceAttributeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateInstanceAttributeRequest.getter(UpdateInstanceAttributeRequest::instanceId)).setter(UpdateInstanceAttributeRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeType").getter(UpdateInstanceAttributeRequest.getter(UpdateInstanceAttributeRequest::attributeTypeAsString)).setter(UpdateInstanceAttributeRequest.setter(Builder::attributeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AttributeType").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(UpdateInstanceAttributeRequest.getter(UpdateInstanceAttributeRequest::value)).setter(UpdateInstanceAttributeRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ATTRIBUTE_TYPE_FIELD, VALUE_FIELD));
    private final String instanceId;
    private final String attributeType;
    private final String value;

    private UpdateInstanceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.attributeType = builder.attributeType;
        this.value = builder.value;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceAttributeType attributeType() {
        return InstanceAttributeType.fromValue(this.attributeType);
    }

    public final String attributeTypeAsString() {
        return this.attributeType;
    }

    public final String value() {
        return this.value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceAttributeRequest)) {
            return false;
        }
        UpdateInstanceAttributeRequest other = (UpdateInstanceAttributeRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.attributeTypeAsString(), other.attributeTypeAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInstanceAttributeRequest").add("InstanceId", (Object)this.instanceId()).add("AttributeType", (Object)this.attributeTypeAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AttributeType": {
                return Optional.ofNullable(clazz.cast(this.attributeTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceAttributeRequest, T> g) {
        return obj -> g.apply((UpdateInstanceAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String attributeType;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceAttributeRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.attributeType(model.attributeType);
            this.value(model.value);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(InstanceAttributeType attributeType) {
            this.attributeType(attributeType == null ? null : attributeType.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceAttributeRequest build() {
            return new UpdateInstanceAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInstanceAttributeRequest> {
        public Builder instanceId(String var1);

        public Builder attributeType(String var1);

        public Builder attributeType(InstanceAttributeType var1);

        public Builder value(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

