/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary;

public class SearchSecurityProfilesIterable
implements SdkIterable<SearchSecurityProfilesResponse> {
    private final ConnectClient client;
    private final SearchSecurityProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSecurityProfilesIterable(ConnectClient client, SearchSecurityProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchSecurityProfilesResponseFetcher();
    }

    public Iterator<SearchSecurityProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityProfileSearchSummary> securityProfiles() {
        Function<SearchSecurityProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfiles() != null) {
                return response.securityProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchSecurityProfilesResponseFetcher
    implements SyncPageFetcher<SearchSecurityProfilesResponse> {
        private SearchSecurityProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchSecurityProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSecurityProfilesResponse nextPage(SearchSecurityProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchSecurityProfilesIterable.this.client.searchSecurityProfiles(SearchSecurityProfilesIterable.this.firstRequest);
            }
            return SearchSecurityProfilesIterable.this.client.searchSecurityProfiles((SearchSecurityProfilesRequest)((Object)SearchSecurityProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

