/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactSearchSummary;
import software.amazon.awssdk.services.connect.model.SearchContactsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactsResponse;

public class SearchContactsPublisher
implements SdkPublisher<SearchContactsResponse> {
    private final ConnectAsyncClient client;
    private final SearchContactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchContactsPublisher(ConnectAsyncClient client, SearchContactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchContactsPublisher(ConnectAsyncClient client, SearchContactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchContactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchContactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactSearchSummary> contacts() {
        Function<SearchContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contacts() != null) {
                return response.contacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchContactsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchContactsResponseFetcher
    implements AsyncPageFetcher<SearchContactsResponse> {
        private SearchContactsResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchContactsResponse> nextPage(SearchContactsResponse previousPage) {
            if (previousPage == null) {
                return SearchContactsPublisher.this.client.searchContacts(SearchContactsPublisher.this.firstRequest);
            }
            return SearchContactsPublisher.this.client.searchContacts((SearchContactsRequest)((Object)SearchContactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

