/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.EvaluationSummary;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse;

public class ListContactEvaluationsIterable
implements SdkIterable<ListContactEvaluationsResponse> {
    private final ConnectClient client;
    private final ListContactEvaluationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactEvaluationsIterable(ConnectClient client, ListContactEvaluationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactEvaluationsResponseFetcher();
    }

    public Iterator<ListContactEvaluationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationSummary> evaluationSummaryList() {
        Function<ListContactEvaluationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationSummaryList() != null) {
                return response.evaluationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactEvaluationsResponseFetcher
    implements SyncPageFetcher<ListContactEvaluationsResponse> {
        private ListContactEvaluationsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactEvaluationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactEvaluationsResponse nextPage(ListContactEvaluationsResponse previousPage) {
            if (previousPage == null) {
                return ListContactEvaluationsIterable.this.client.listContactEvaluations(ListContactEvaluationsIterable.this.firstRequest);
            }
            return ListContactEvaluationsIterable.this.client.listContactEvaluations((ListContactEvaluationsRequest)((Object)ListContactEvaluationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

