/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse;

public class ListLambdaFunctionsIterable
implements SdkIterable<ListLambdaFunctionsResponse> {
    private final ConnectClient client;
    private final ListLambdaFunctionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLambdaFunctionsIterable(ConnectClient client, ListLambdaFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLambdaFunctionsResponseFetcher();
    }

    public Iterator<ListLambdaFunctionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> lambdaFunctions() {
        Function<ListLambdaFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lambdaFunctions() != null) {
                return response.lambdaFunctions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLambdaFunctionsResponseFetcher
    implements SyncPageFetcher<ListLambdaFunctionsResponse> {
        private ListLambdaFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLambdaFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLambdaFunctionsResponse nextPage(ListLambdaFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListLambdaFunctionsIterable.this.client.listLambdaFunctions(ListLambdaFunctionsIterable.this.firstRequest);
            }
            return ListLambdaFunctionsIterable.this.client.listLambdaFunctions((ListLambdaFunctionsRequest)((Object)ListLambdaFunctionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

