/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoutingProfileAgentAvailabilityTimerRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateRoutingProfileAgentAvailabilityTimerRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateRoutingProfileAgentAvailabilityTimerRequest.getter(UpdateRoutingProfileAgentAvailabilityTimerRequest::instanceId)).setter(UpdateRoutingProfileAgentAvailabilityTimerRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(UpdateRoutingProfileAgentAvailabilityTimerRequest.getter(UpdateRoutingProfileAgentAvailabilityTimerRequest::routingProfileId)).setter(UpdateRoutingProfileAgentAvailabilityTimerRequest.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<String> AGENT_AVAILABILITY_TIMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentAvailabilityTimer").getter(UpdateRoutingProfileAgentAvailabilityTimerRequest.getter(UpdateRoutingProfileAgentAvailabilityTimerRequest::agentAvailabilityTimerAsString)).setter(UpdateRoutingProfileAgentAvailabilityTimerRequest.setter(Builder::agentAvailabilityTimer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentAvailabilityTimer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ROUTING_PROFILE_ID_FIELD, AGENT_AVAILABILITY_TIMER_FIELD));
    private final String instanceId;
    private final String routingProfileId;
    private final String agentAvailabilityTimer;

    private UpdateRoutingProfileAgentAvailabilityTimerRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.agentAvailabilityTimer = builder.agentAvailabilityTimer;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final AgentAvailabilityTimer agentAvailabilityTimer() {
        return AgentAvailabilityTimer.fromValue(this.agentAvailabilityTimer);
    }

    public final String agentAvailabilityTimerAsString() {
        return this.agentAvailabilityTimer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAvailabilityTimerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileAgentAvailabilityTimerRequest)) {
            return false;
        }
        UpdateRoutingProfileAgentAvailabilityTimerRequest other = (UpdateRoutingProfileAgentAvailabilityTimerRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && Objects.equals(this.agentAvailabilityTimerAsString(), other.agentAvailabilityTimerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRoutingProfileAgentAvailabilityTimerRequest").add("InstanceId", (Object)this.instanceId()).add("RoutingProfileId", (Object)this.routingProfileId()).add("AgentAvailabilityTimer", (Object)this.agentAvailabilityTimerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "AgentAvailabilityTimer": {
                return Optional.ofNullable(clazz.cast(this.agentAvailabilityTimerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingProfileAgentAvailabilityTimerRequest, T> g) {
        return obj -> g.apply((UpdateRoutingProfileAgentAvailabilityTimerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String routingProfileId;
        private String agentAvailabilityTimer;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingProfileAgentAvailabilityTimerRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.routingProfileId(model.routingProfileId);
            this.agentAvailabilityTimer(model.agentAvailabilityTimer);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getAgentAvailabilityTimer() {
            return this.agentAvailabilityTimer;
        }

        public final void setAgentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
        }

        @Override
        public final Builder agentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
            return this;
        }

        @Override
        public final Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer) {
            this.agentAvailabilityTimer(agentAvailabilityTimer == null ? null : agentAvailabilityTimer.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingProfileAgentAvailabilityTimerRequest build() {
            return new UpdateRoutingProfileAgentAvailabilityTimerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoutingProfileAgentAvailabilityTimerRequest> {
        public Builder instanceId(String var1);

        public Builder routingProfileId(String var1);

        public Builder agentAvailabilityTimer(String var1);

        public Builder agentAvailabilityTimer(AgentAvailabilityTimer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

