/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AnswerMachineDetectionConfig;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.services.connect.model.TrafficType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOutboundVoiceContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartOutboundVoiceContactRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::name)).setter(StartOutboundVoiceContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::description)).setter(StartOutboundVoiceContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::references)).setter(StartOutboundVoiceContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::relatedContactId)).setter(StartOutboundVoiceContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPhoneNumber").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::destinationPhoneNumber)).setter(StartOutboundVoiceContactRequest.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::contactFlowId)).setter(StartOutboundVoiceContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::instanceId)).setter(StartOutboundVoiceContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::clientToken)).setter(StartOutboundVoiceContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SOURCE_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePhoneNumber").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::sourcePhoneNumber)).setter(StartOutboundVoiceContactRequest.setter(Builder::sourcePhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePhoneNumber").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::queueId)).setter(StartOutboundVoiceContactRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::attributes)).setter(StartOutboundVoiceContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AnswerMachineDetectionConfig> ANSWER_MACHINE_DETECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnswerMachineDetectionConfig").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::answerMachineDetectionConfig)).setter(StartOutboundVoiceContactRequest.setter(Builder::answerMachineDetectionConfig)).constructor(AnswerMachineDetectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerMachineDetectionConfig").build()}).build();
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::campaignId)).setter(StartOutboundVoiceContactRequest.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()}).build();
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficType").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::trafficTypeAsString)).setter(StartOutboundVoiceContactRequest.setter(Builder::trafficType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, REFERENCES_FIELD, RELATED_CONTACT_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD, CONTACT_FLOW_ID_FIELD, INSTANCE_ID_FIELD, CLIENT_TOKEN_FIELD, SOURCE_PHONE_NUMBER_FIELD, QUEUE_ID_FIELD, ATTRIBUTES_FIELD, ANSWER_MACHINE_DETECTION_CONFIG_FIELD, CAMPAIGN_ID_FIELD, TRAFFIC_TYPE_FIELD));
    private final String name;
    private final String description;
    private final Map<String, Reference> references;
    private final String relatedContactId;
    private final String destinationPhoneNumber;
    private final String contactFlowId;
    private final String instanceId;
    private final String clientToken;
    private final String sourcePhoneNumber;
    private final String queueId;
    private final Map<String, String> attributes;
    private final AnswerMachineDetectionConfig answerMachineDetectionConfig;
    private final String campaignId;
    private final String trafficType;

    private StartOutboundVoiceContactRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.references = builder.references;
        this.relatedContactId = builder.relatedContactId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.contactFlowId = builder.contactFlowId;
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.sourcePhoneNumber = builder.sourcePhoneNumber;
        this.queueId = builder.queueId;
        this.attributes = builder.attributes;
        this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
        this.campaignId = builder.campaignId;
        this.trafficType = builder.trafficType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public final Map<String, Reference> references() {
        return this.references;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String sourcePhoneNumber() {
        return this.sourcePhoneNumber;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final AnswerMachineDetectionConfig answerMachineDetectionConfig() {
        return this.answerMachineDetectionConfig;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final TrafficType trafficType() {
        return TrafficType.fromValue(this.trafficType);
    }

    public final String trafficTypeAsString() {
        return this.trafficType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.answerMachineDetectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundVoiceContactRequest)) {
            return false;
        }
        StartOutboundVoiceContactRequest other = (StartOutboundVoiceContactRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sourcePhoneNumber(), other.sourcePhoneNumber()) && Objects.equals(this.queueId(), other.queueId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.answerMachineDetectionConfig(), other.answerMachineDetectionConfig()) && Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.trafficTypeAsString(), other.trafficTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartOutboundVoiceContactRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("References", this.hasReferences() ? this.references() : null).add("RelatedContactId", (Object)this.relatedContactId()).add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("ContactFlowId", (Object)this.contactFlowId()).add("InstanceId", (Object)this.instanceId()).add("ClientToken", (Object)this.clientToken()).add("SourcePhoneNumber", (Object)this.sourcePhoneNumber()).add("QueueId", (Object)this.queueId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AnswerMachineDetectionConfig", (Object)this.answerMachineDetectionConfig()).add("CampaignId", (Object)this.campaignId()).add("TrafficType", (Object)this.trafficTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SourcePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.sourcePhoneNumber()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "AnswerMachineDetectionConfig": {
                return Optional.ofNullable(clazz.cast(this.answerMachineDetectionConfig()));
            }
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundVoiceContactRequest, T> g) {
        return obj -> g.apply((StartOutboundVoiceContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private String relatedContactId;
        private String destinationPhoneNumber;
        private String contactFlowId;
        private String instanceId;
        private String clientToken;
        private String sourcePhoneNumber;
        private String queueId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private AnswerMachineDetectionConfig answerMachineDetectionConfig;
        private String campaignId;
        private String trafficType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundVoiceContactRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.references(model.references);
            this.relatedContactId(model.relatedContactId);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.contactFlowId(model.contactFlowId);
            this.instanceId(model.instanceId);
            this.clientToken(model.clientToken);
            this.sourcePhoneNumber(model.sourcePhoneNumber);
            this.queueId(model.queueId);
            this.attributes(model.attributes);
            this.answerMachineDetectionConfig(model.answerMachineDetectionConfig);
            this.campaignId(model.campaignId);
            this.trafficType(model.trafficType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourcePhoneNumber() {
            return this.sourcePhoneNumber;
        }

        public final void setSourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
        }

        @Override
        public final Builder sourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final AnswerMachineDetectionConfig.Builder getAnswerMachineDetectionConfig() {
            return this.answerMachineDetectionConfig != null ? this.answerMachineDetectionConfig.toBuilder() : null;
        }

        public final void setAnswerMachineDetectionConfig(AnswerMachineDetectionConfig.BuilderImpl answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig != null ? answerMachineDetectionConfig.build() : null;
        }

        @Override
        public final Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig;
            return this;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getTrafficType() {
            return this.trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundVoiceContactRequest build() {
            return new StartOutboundVoiceContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartOutboundVoiceContactRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder references(Map<String, Reference> var1);

        public Builder relatedContactId(String var1);

        public Builder destinationPhoneNumber(String var1);

        public Builder contactFlowId(String var1);

        public Builder instanceId(String var1);

        public Builder clientToken(String var1);

        public Builder sourcePhoneNumber(String var1);

        public Builder queueId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig var1);

        default public Builder answerMachineDetectionConfig(Consumer<AnswerMachineDetectionConfig.Builder> answerMachineDetectionConfig) {
            return this.answerMachineDetectionConfig((AnswerMachineDetectionConfig)((AnswerMachineDetectionConfig.Builder)AnswerMachineDetectionConfig.builder().applyMutation(answerMachineDetectionConfig)).build());
        }

        public Builder campaignId(String var1);

        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

