/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFederationTokenResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetFederationTokenResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(GetFederationTokenResponse.getter(GetFederationTokenResponse::credentials)).setter(GetFederationTokenResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<String> SIGN_IN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignInUrl").getter(GetFederationTokenResponse.getter(GetFederationTokenResponse::signInUrl)).setter(GetFederationTokenResponse.setter(Builder::signInUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInUrl").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(GetFederationTokenResponse.getter(GetFederationTokenResponse::userArn)).setter(GetFederationTokenResponse.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(GetFederationTokenResponse.getter(GetFederationTokenResponse::userId)).setter(GetFederationTokenResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, SIGN_IN_URL_FIELD, USER_ARN_FIELD, USER_ID_FIELD));
    private final Credentials credentials;
    private final String signInUrl;
    private final String userArn;
    private final String userId;

    private GetFederationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.signInUrl = builder.signInUrl;
        this.userArn = builder.userArn;
        this.userId = builder.userId;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final String signInUrl() {
        return this.signInUrl;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.signInUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenResponse)) {
            return false;
        }
        GetFederationTokenResponse other = (GetFederationTokenResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.signInUrl(), other.signInUrl()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"GetFederationTokenResponse").add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("SignInUrl", (Object)this.signInUrl()).add("UserArn", (Object)this.userArn()).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "SignInUrl": {
                return Optional.ofNullable(clazz.cast(this.signInUrl()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFederationTokenResponse, T> g) {
        return obj -> g.apply((GetFederationTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private String signInUrl;
        private String userArn;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.signInUrl(model.signInUrl);
            this.userArn(model.userArn);
            this.userId(model.userId);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getSignInUrl() {
            return this.signInUrl;
        }

        public final void setSignInUrl(String signInUrl) {
            this.signInUrl = signInUrl;
        }

        @Override
        public final Builder signInUrl(String signInUrl) {
            this.signInUrl = signInUrl;
            return this;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public GetFederationTokenResponse build() {
            return new GetFederationTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFederationTokenResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder signInUrl(String var1);

        public Builder userArn(String var1);

        public Builder userId(String var1);
    }
}

