/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.MeetingFeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioFeatures
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioFeatures> {
    private static final SdkField<String> ECHO_REDUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EchoReduction").getter(AudioFeatures.getter(AudioFeatures::echoReductionAsString)).setter(AudioFeatures.setter(Builder::echoReduction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EchoReduction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECHO_REDUCTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String echoReduction;

    private AudioFeatures(BuilderImpl builder) {
        this.echoReduction = builder.echoReduction;
    }

    public final MeetingFeatureStatus echoReduction() {
        return MeetingFeatureStatus.fromValue(this.echoReduction);
    }

    public final String echoReductionAsString() {
        return this.echoReduction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.echoReductionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioFeatures)) {
            return false;
        }
        AudioFeatures other = (AudioFeatures)obj;
        return Objects.equals(this.echoReductionAsString(), other.echoReductionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AudioFeatures").add("EchoReduction", (Object)this.echoReductionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EchoReduction": {
                return Optional.ofNullable(clazz.cast(this.echoReductionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioFeatures, T> g) {
        return obj -> g.apply((AudioFeatures)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String echoReduction;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioFeatures model) {
            this.echoReduction(model.echoReduction);
        }

        public final String getEchoReduction() {
            return this.echoReduction;
        }

        public final void setEchoReduction(String echoReduction) {
            this.echoReduction = echoReduction;
        }

        @Override
        public final Builder echoReduction(String echoReduction) {
            this.echoReduction = echoReduction;
            return this;
        }

        @Override
        public final Builder echoReduction(MeetingFeatureStatus echoReduction) {
            this.echoReduction(echoReduction == null ? null : echoReduction.toString());
            return this;
        }

        public AudioFeatures build() {
            return new AudioFeatures(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioFeatures> {
        public Builder echoReduction(String var1);

        public Builder echoReduction(MeetingFeatureStatus var1);
    }
}

