/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.DisconnectReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StopContactRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StopContactRequest.getter(StopContactRequest::contactId)).setter(StopContactRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StopContactRequest.getter(StopContactRequest::instanceId)).setter(StopContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<DisconnectReason> DISCONNECT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisconnectReason").getter(StopContactRequest.getter(StopContactRequest::disconnectReason)).setter(StopContactRequest.setter(Builder::disconnectReason)).constructor(DisconnectReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, INSTANCE_ID_FIELD, DISCONNECT_REASON_FIELD));
    private final String contactId;
    private final String instanceId;
    private final DisconnectReason disconnectReason;

    private StopContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.instanceId = builder.instanceId;
        this.disconnectReason = builder.disconnectReason;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final DisconnectReason disconnectReason() {
        return this.disconnectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopContactRequest)) {
            return false;
        }
        StopContactRequest other = (StopContactRequest)((Object)obj);
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.disconnectReason(), other.disconnectReason());
    }

    public final String toString() {
        return ToString.builder((String)"StopContactRequest").add("ContactId", (Object)this.contactId()).add("InstanceId", (Object)this.instanceId()).add("DisconnectReason", (Object)this.disconnectReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DisconnectReason": {
                return Optional.ofNullable(clazz.cast(this.disconnectReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopContactRequest, T> g) {
        return obj -> g.apply((StopContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String contactId;
        private String instanceId;
        private DisconnectReason disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopContactRequest model) {
            super(model);
            this.contactId(model.contactId);
            this.instanceId(model.instanceId);
            this.disconnectReason(model.disconnectReason);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final DisconnectReason.Builder getDisconnectReason() {
            return this.disconnectReason != null ? this.disconnectReason.toBuilder() : null;
        }

        public final void setDisconnectReason(DisconnectReason.BuilderImpl disconnectReason) {
            this.disconnectReason = disconnectReason != null ? disconnectReason.build() : null;
        }

        @Override
        public final Builder disconnectReason(DisconnectReason disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopContactRequest build() {
            return new StopContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopContactRequest> {
        public Builder contactId(String var1);

        public Builder instanceId(String var1);

        public Builder disconnectReason(DisconnectReason var1);

        default public Builder disconnectReason(Consumer<DisconnectReason.Builder> disconnectReason) {
            return this.disconnectReason((DisconnectReason)((DisconnectReason.Builder)DisconnectReason.builder().applyMutation(disconnectReason)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

