/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary;

public class ListRoutingProfileQueuesPublisher
implements SdkPublisher<ListRoutingProfileQueuesResponse> {
    private final ConnectAsyncClient client;
    private final ListRoutingProfileQueuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoutingProfileQueuesPublisher(ConnectAsyncClient client, ListRoutingProfileQueuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoutingProfileQueuesPublisher(ConnectAsyncClient client, ListRoutingProfileQueuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoutingProfileQueuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoutingProfileQueuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList() {
        Function<ListRoutingProfileQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingProfileQueueConfigSummaryList() != null) {
                return response.routingProfileQueueConfigSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoutingProfileQueuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoutingProfileQueuesResponseFetcher
    implements AsyncPageFetcher<ListRoutingProfileQueuesResponse> {
        private ListRoutingProfileQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingProfileQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoutingProfileQueuesResponse> nextPage(ListRoutingProfileQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingProfileQueuesPublisher.this.client.listRoutingProfileQueues(ListRoutingProfileQueuesPublisher.this.firstRequest);
            }
            return ListRoutingProfileQueuesPublisher.this.client.listRoutingProfileQueues((ListRoutingProfileQueuesRequest)((Object)ListRoutingProfileQueuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

