/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about properties for a question in an evaluation form. The question type properties must be either for a
 * numeric question or a single select question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormQuestionTypeProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormQuestionTypeProperties.Builder, EvaluationFormQuestionTypeProperties> {
    private static final SdkField<EvaluationFormNumericQuestionProperties> NUMERIC_FIELD = SdkField
            .<EvaluationFormNumericQuestionProperties> builder(MarshallingType.SDK_POJO).memberName("Numeric")
            .getter(getter(EvaluationFormQuestionTypeProperties::numeric)).setter(setter(Builder::numeric))
            .constructor(EvaluationFormNumericQuestionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Numeric").build()).build();

    private static final SdkField<EvaluationFormSingleSelectQuestionProperties> SINGLE_SELECT_FIELD = SdkField
            .<EvaluationFormSingleSelectQuestionProperties> builder(MarshallingType.SDK_POJO).memberName("SingleSelect")
            .getter(getter(EvaluationFormQuestionTypeProperties::singleSelect)).setter(setter(Builder::singleSelect))
            .constructor(EvaluationFormSingleSelectQuestionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSelect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERIC_FIELD,
            SINGLE_SELECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final EvaluationFormNumericQuestionProperties numeric;

    private final EvaluationFormSingleSelectQuestionProperties singleSelect;

    private final Type type;

    private EvaluationFormQuestionTypeProperties(BuilderImpl builder) {
        this.numeric = builder.numeric;
        this.singleSelect = builder.singleSelect;
        this.type = builder.type;
    }

    /**
     * <p>
     * The properties of the numeric question.
     * </p>
     * 
     * @return The properties of the numeric question.
     */
    public final EvaluationFormNumericQuestionProperties numeric() {
        return numeric;
    }

    /**
     * <p>
     * The properties of the numeric question.
     * </p>
     * 
     * @return The properties of the numeric question.
     */
    public final EvaluationFormSingleSelectQuestionProperties singleSelect() {
        return singleSelect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numeric());
        hashCode = 31 * hashCode + Objects.hashCode(singleSelect());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormQuestionTypeProperties)) {
            return false;
        }
        EvaluationFormQuestionTypeProperties other = (EvaluationFormQuestionTypeProperties) obj;
        return Objects.equals(numeric(), other.numeric()) && Objects.equals(singleSelect(), other.singleSelect());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormQuestionTypeProperties").add("Numeric", numeric())
                .add("SingleSelect", singleSelect()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Numeric":
            return Optional.ofNullable(clazz.cast(numeric()));
        case "SingleSelect":
            return Optional.ofNullable(clazz.cast(singleSelect()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #numeric()} initialized to the given value.
     *
     * <p>
     * The properties of the numeric question.
     * </p>
     * 
     * @param numeric
     *        The properties of the numeric question.
     */
    public static EvaluationFormQuestionTypeProperties fromNumeric(EvaluationFormNumericQuestionProperties numeric) {
        return builder().numeric(numeric).build();
    }

    /**
     * Create an instance of this class with {@link #numeric()} initialized to the given value.
     *
     * <p>
     * The properties of the numeric question.
     * </p>
     * 
     * @param numeric
     *        The properties of the numeric question.
     */
    public static EvaluationFormQuestionTypeProperties fromNumeric(
            Consumer<EvaluationFormNumericQuestionProperties.Builder> numeric) {
        EvaluationFormNumericQuestionProperties.Builder builder = EvaluationFormNumericQuestionProperties.builder();
        numeric.accept(builder);
        return fromNumeric(builder.build());
    }

    /**
     * Create an instance of this class with {@link #singleSelect()} initialized to the given value.
     *
     * <p>
     * The properties of the numeric question.
     * </p>
     * 
     * @param singleSelect
     *        The properties of the numeric question.
     */
    public static EvaluationFormQuestionTypeProperties fromSingleSelect(EvaluationFormSingleSelectQuestionProperties singleSelect) {
        return builder().singleSelect(singleSelect).build();
    }

    /**
     * Create an instance of this class with {@link #singleSelect()} initialized to the given value.
     *
     * <p>
     * The properties of the numeric question.
     * </p>
     * 
     * @param singleSelect
     *        The properties of the numeric question.
     */
    public static EvaluationFormQuestionTypeProperties fromSingleSelect(
            Consumer<EvaluationFormSingleSelectQuestionProperties.Builder> singleSelect) {
        EvaluationFormSingleSelectQuestionProperties.Builder builder = EvaluationFormSingleSelectQuestionProperties.builder();
        singleSelect.accept(builder);
        return fromSingleSelect(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormQuestionTypeProperties, T> g) {
        return obj -> g.apply((EvaluationFormQuestionTypeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormQuestionTypeProperties> {
        /**
         * <p>
         * The properties of the numeric question.
         * </p>
         * 
         * @param numeric
         *        The properties of the numeric question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numeric(EvaluationFormNumericQuestionProperties numeric);

        /**
         * <p>
         * The properties of the numeric question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormNumericQuestionProperties.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormNumericQuestionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormNumericQuestionProperties.Builder#build()} is
         * called immediately and its result is passed to {@link #numeric(EvaluationFormNumericQuestionProperties)}.
         * 
         * @param numeric
         *        a consumer that will call methods on {@link EvaluationFormNumericQuestionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numeric(EvaluationFormNumericQuestionProperties)
         */
        default Builder numeric(Consumer<EvaluationFormNumericQuestionProperties.Builder> numeric) {
            return numeric(EvaluationFormNumericQuestionProperties.builder().applyMutation(numeric).build());
        }

        /**
         * <p>
         * The properties of the numeric question.
         * </p>
         * 
         * @param singleSelect
         *        The properties of the numeric question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSelect(EvaluationFormSingleSelectQuestionProperties singleSelect);

        /**
         * <p>
         * The properties of the numeric question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormSingleSelectQuestionProperties.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormSingleSelectQuestionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormSingleSelectQuestionProperties.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #singleSelect(EvaluationFormSingleSelectQuestionProperties)}.
         * 
         * @param singleSelect
         *        a consumer that will call methods on {@link EvaluationFormSingleSelectQuestionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleSelect(EvaluationFormSingleSelectQuestionProperties)
         */
        default Builder singleSelect(Consumer<EvaluationFormSingleSelectQuestionProperties.Builder> singleSelect) {
            return singleSelect(EvaluationFormSingleSelectQuestionProperties.builder().applyMutation(singleSelect).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationFormNumericQuestionProperties numeric;

        private EvaluationFormSingleSelectQuestionProperties singleSelect;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormQuestionTypeProperties model) {
            numeric(model.numeric);
            singleSelect(model.singleSelect);
        }

        public final EvaluationFormNumericQuestionProperties.Builder getNumeric() {
            return numeric != null ? numeric.toBuilder() : null;
        }

        public final void setNumeric(EvaluationFormNumericQuestionProperties.BuilderImpl numeric) {
            Object oldValue = this.numeric;
            this.numeric = numeric != null ? numeric.build() : null;
            handleUnionValueChange(Type.NUMERIC, oldValue, this.numeric);
        }

        @Override
        public final Builder numeric(EvaluationFormNumericQuestionProperties numeric) {
            Object oldValue = this.numeric;
            this.numeric = numeric;
            handleUnionValueChange(Type.NUMERIC, oldValue, this.numeric);
            return this;
        }

        public final EvaluationFormSingleSelectQuestionProperties.Builder getSingleSelect() {
            return singleSelect != null ? singleSelect.toBuilder() : null;
        }

        public final void setSingleSelect(EvaluationFormSingleSelectQuestionProperties.BuilderImpl singleSelect) {
            Object oldValue = this.singleSelect;
            this.singleSelect = singleSelect != null ? singleSelect.build() : null;
            handleUnionValueChange(Type.SINGLE_SELECT, oldValue, this.singleSelect);
        }

        @Override
        public final Builder singleSelect(EvaluationFormSingleSelectQuestionProperties singleSelect) {
            Object oldValue = this.singleSelect;
            this.singleSelect = singleSelect;
            handleUnionValueChange(Type.SINGLE_SELECT, oldValue, this.singleSelect);
            return this;
        }

        @Override
        public EvaluationFormQuestionTypeProperties build() {
            return new EvaluationFormQuestionTypeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationFormQuestionTypeProperties#type()
     */
    public enum Type {
        NUMERIC,

        SINGLE_SELECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
