/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.QuickConnect;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse;

public class SearchQuickConnectsIterable
implements SdkIterable<SearchQuickConnectsResponse> {
    private final ConnectClient client;
    private final SearchQuickConnectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchQuickConnectsIterable(ConnectClient client, SearchQuickConnectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchQuickConnectsResponseFetcher();
    }

    public Iterator<SearchQuickConnectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QuickConnect> quickConnects() {
        Function<SearchQuickConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickConnects() != null) {
                return response.quickConnects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchQuickConnectsResponseFetcher
    implements SyncPageFetcher<SearchQuickConnectsResponse> {
        private SearchQuickConnectsResponseFetcher() {
        }

        public boolean hasNextPage(SearchQuickConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchQuickConnectsResponse nextPage(SearchQuickConnectsResponse previousPage) {
            if (previousPage == null) {
                return SearchQuickConnectsIterable.this.client.searchQuickConnects(SearchQuickConnectsIterable.this.firstRequest);
            }
            return SearchQuickConnectsIterable.this.client.searchQuickConnects((SearchQuickConnectsRequest)((Object)SearchQuickConnectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

