/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RehydrationType {
    ENTIRE_PAST_SESSION("ENTIRE_PAST_SESSION"),
    FROM_SEGMENT("FROM_SEGMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RehydrationType> VALUE_MAP;
    private final String value;

    private RehydrationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RehydrationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RehydrationType> knownValues() {
        EnumSet<RehydrationType> knownValues = EnumSet.allOf(RehydrationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RehydrationType.class, RehydrationType::toString);
    }
}

