/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse;

public class ListEvaluationFormVersionsIterable
implements SdkIterable<ListEvaluationFormVersionsResponse> {
    private final ConnectClient client;
    private final ListEvaluationFormVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEvaluationFormVersionsIterable(ConnectClient client, ListEvaluationFormVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEvaluationFormVersionsResponseFetcher();
    }

    public Iterator<ListEvaluationFormVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationFormVersionSummary> evaluationFormVersionSummaryList() {
        Function<ListEvaluationFormVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationFormVersionSummaryList() != null) {
                return response.evaluationFormVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEvaluationFormVersionsResponseFetcher
    implements SyncPageFetcher<ListEvaluationFormVersionsResponse> {
        private ListEvaluationFormVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluationFormVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEvaluationFormVersionsResponse nextPage(ListEvaluationFormVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluationFormVersionsIterable.this.client.listEvaluationFormVersions(ListEvaluationFormVersionsIterable.this.firstRequest);
            }
            return ListEvaluationFormVersionsIterable.this.client.listEvaluationFormVersions((ListEvaluationFormVersionsRequest)((Object)ListEvaluationFormVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

