/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.HoursOfOperationSummary;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;

public class ListHoursOfOperationsIterable
implements SdkIterable<ListHoursOfOperationsResponse> {
    private final ConnectClient client;
    private final ListHoursOfOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHoursOfOperationsIterable(ConnectClient client, ListHoursOfOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHoursOfOperationsResponseFetcher();
    }

    public Iterator<ListHoursOfOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HoursOfOperationSummary> hoursOfOperationSummaryList() {
        Function<ListHoursOfOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperationSummaryList() != null) {
                return response.hoursOfOperationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHoursOfOperationsResponseFetcher
    implements SyncPageFetcher<ListHoursOfOperationsResponse> {
        private ListHoursOfOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListHoursOfOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHoursOfOperationsResponse nextPage(ListHoursOfOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListHoursOfOperationsIterable.this.client.listHoursOfOperations(ListHoursOfOperationsIterable.this.firstRequest);
            }
            return ListHoursOfOperationsIterable.this.client.listHoursOfOperations((ListHoursOfOperationsRequest)((Object)ListHoursOfOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

