/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantTokenCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantTokenCredentials> {
    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantToken").getter(ParticipantTokenCredentials.getter(ParticipantTokenCredentials::participantToken)).setter(ParticipantTokenCredentials.setter(Builder::participantToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()}).build();
    private static final SdkField<String> EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expiry").getter(ParticipantTokenCredentials.getter(ParticipantTokenCredentials::expiry)).setter(ParticipantTokenCredentials.setter(Builder::expiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_TOKEN_FIELD, EXPIRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String participantToken;
    private final String expiry;

    private ParticipantTokenCredentials(BuilderImpl builder) {
        this.participantToken = builder.participantToken;
        this.expiry = builder.expiry;
    }

    public final String participantToken() {
        return this.participantToken;
    }

    public final String expiry() {
        return this.expiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantTokenCredentials)) {
            return false;
        }
        ParticipantTokenCredentials other = (ParticipantTokenCredentials)obj;
        return Objects.equals(this.participantToken(), other.participantToken()) && Objects.equals(this.expiry(), other.expiry());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantTokenCredentials").add("ParticipantToken", (Object)this.participantToken()).add("Expiry", (Object)this.expiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParticipantToken": {
                return Optional.ofNullable(clazz.cast(this.participantToken()));
            }
            case "Expiry": {
                return Optional.ofNullable(clazz.cast(this.expiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipantTokenCredentials, T> g) {
        return obj -> g.apply((ParticipantTokenCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantToken;
        private String expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantTokenCredentials model) {
            this.participantToken(model.participantToken);
            this.expiry(model.expiry);
        }

        public final String getParticipantToken() {
            return this.participantToken;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        public final String getExpiry() {
            return this.expiry;
        }

        public final void setExpiry(String expiry) {
            this.expiry = expiry;
        }

        @Override
        public final Builder expiry(String expiry) {
            this.expiry = expiry;
            return this;
        }

        public ParticipantTokenCredentials build() {
            return new ParticipantTokenCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantTokenCredentials> {
        public Builder participantToken(String var1);

        public Builder expiry(String var1);
    }
}

