/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PropertyValidationExceptionReason {
    INVALID_FORMAT("INVALID_FORMAT"),
    UNIQUE_CONSTRAINT_VIOLATED("UNIQUE_CONSTRAINT_VIOLATED"),
    REFERENCED_RESOURCE_NOT_FOUND("REFERENCED_RESOURCE_NOT_FOUND"),
    RESOURCE_NAME_ALREADY_EXISTS("RESOURCE_NAME_ALREADY_EXISTS"),
    REQUIRED_PROPERTY_MISSING("REQUIRED_PROPERTY_MISSING"),
    NOT_SUPPORTED("NOT_SUPPORTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PropertyValidationExceptionReason> VALUE_MAP;
    private final String value;

    private PropertyValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PropertyValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PropertyValidationExceptionReason> knownValues() {
        EnumSet<PropertyValidationExceptionReason> knownValues = EnumSet.allOf(PropertyValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PropertyValidationExceptionReason.class, PropertyValidationExceptionReason::toString);
    }
}

