/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VocabularyState {
    CREATION_IN_PROGRESS("CREATION_IN_PROGRESS"),
    ACTIVE("ACTIVE"),
    CREATION_FAILED("CREATION_FAILED"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VocabularyState> VALUE_MAP;
    private final String value;

    private VocabularyState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VocabularyState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VocabularyState> knownValues() {
        EnumSet<VocabularyState> knownValues = EnumSet.allOf(VocabularyState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VocabularyState.class, VocabularyState::toString);
    }
}

