/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.VocabularyState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVocabularyResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreateVocabularyResponse> {
    private static final SdkField<String> VOCABULARY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyArn").getter(CreateVocabularyResponse.getter(CreateVocabularyResponse::vocabularyArn)).setter(CreateVocabularyResponse.setter(Builder::vocabularyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyArn").build()}).build();
    private static final SdkField<String> VOCABULARY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyId").getter(CreateVocabularyResponse.getter(CreateVocabularyResponse::vocabularyId)).setter(CreateVocabularyResponse.setter(Builder::vocabularyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateVocabularyResponse.getter(CreateVocabularyResponse::stateAsString)).setter(CreateVocabularyResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_ARN_FIELD, VOCABULARY_ID_FIELD, STATE_FIELD));
    private final String vocabularyArn;
    private final String vocabularyId;
    private final String state;

    private CreateVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyArn = builder.vocabularyArn;
        this.vocabularyId = builder.vocabularyId;
        this.state = builder.state;
    }

    public final String vocabularyArn() {
        return this.vocabularyArn;
    }

    public final String vocabularyId() {
        return this.vocabularyId;
    }

    public final VocabularyState state() {
        return VocabularyState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyResponse)) {
            return false;
        }
        CreateVocabularyResponse other = (CreateVocabularyResponse)((Object)obj);
        return Objects.equals(this.vocabularyArn(), other.vocabularyArn()) && Objects.equals(this.vocabularyId(), other.vocabularyId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVocabularyResponse").add("VocabularyArn", (Object)this.vocabularyArn()).add("VocabularyId", (Object)this.vocabularyId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyArn": {
                return Optional.ofNullable(clazz.cast(this.vocabularyArn()));
            }
            case "VocabularyId": {
                return Optional.ofNullable(clazz.cast(this.vocabularyId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVocabularyResponse, T> g) {
        return obj -> g.apply((CreateVocabularyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String vocabularyArn;
        private String vocabularyId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVocabularyResponse model) {
            super(model);
            this.vocabularyArn(model.vocabularyArn);
            this.vocabularyId(model.vocabularyId);
            this.state(model.state);
        }

        public final String getVocabularyArn() {
            return this.vocabularyArn;
        }

        public final void setVocabularyArn(String vocabularyArn) {
            this.vocabularyArn = vocabularyArn;
        }

        @Override
        public final Builder vocabularyArn(String vocabularyArn) {
            this.vocabularyArn = vocabularyArn;
            return this;
        }

        public final String getVocabularyId() {
            return this.vocabularyId;
        }

        public final void setVocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
        }

        @Override
        public final Builder vocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VocabularyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public CreateVocabularyResponse build() {
            return new CreateVocabularyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVocabularyResponse> {
        public Builder vocabularyArn(String var1);

        public Builder vocabularyId(String var1);

        public Builder state(String var1);

        public Builder state(VocabularyState var1);
    }
}

