/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse;
import software.amazon.awssdk.services.connect.model.TaskTemplateMetadata;

public class ListTaskTemplatesPublisher
implements SdkPublisher<ListTaskTemplatesResponse> {
    private final ConnectAsyncClient client;
    private final ListTaskTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaskTemplatesPublisher(ConnectAsyncClient client, ListTaskTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaskTemplatesPublisher(ConnectAsyncClient client, ListTaskTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaskTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaskTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TaskTemplateMetadata> taskTemplates() {
        Function<ListTaskTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskTemplates() != null) {
                return response.taskTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTaskTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTaskTemplatesResponseFetcher
    implements AsyncPageFetcher<ListTaskTemplatesResponse> {
        private ListTaskTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaskTemplatesResponse> nextPage(ListTaskTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskTemplatesPublisher.this.client.listTaskTemplates(ListTaskTemplatesPublisher.this.firstRequest);
            }
            return ListTaskTemplatesPublisher.this.client.listTaskTemplates((ListTaskTemplatesRequest)((Object)ListTaskTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

