/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EvaluationFormVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormVersionSummary> {
    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormArn").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::evaluationFormArn)).setter(EvaluationFormVersionSummary.setter(Builder::evaluationFormArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormId").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::evaluationFormId)).setter(EvaluationFormVersionSummary.setter(Builder::evaluationFormId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()}).build();
    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationFormVersion").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::evaluationFormVersion)).setter(EvaluationFormVersionSummary.setter(Builder::evaluationFormVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build()}).build();
    private static final SdkField<Boolean> LOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Locked").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::locked)).setter(EvaluationFormVersionSummary.setter(Builder::locked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locked").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::statusAsString)).setter(EvaluationFormVersionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::createdTime)).setter(EvaluationFormVersionSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::createdBy)).setter(EvaluationFormVersionSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::lastModifiedTime)).setter(EvaluationFormVersionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(EvaluationFormVersionSummary.getter(EvaluationFormVersionSummary::lastModifiedBy)).setter(EvaluationFormVersionSummary.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_ARN_FIELD, EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_VERSION_FIELD, LOCKED_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String evaluationFormArn;
    private final String evaluationFormId;
    private final Integer evaluationFormVersion;
    private final Boolean locked;
    private final String status;
    private final Instant createdTime;
    private final String createdBy;
    private final Instant lastModifiedTime;
    private final String lastModifiedBy;

    private EvaluationFormVersionSummary(BuilderImpl builder) {
        this.evaluationFormArn = builder.evaluationFormArn;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.locked = builder.locked;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    public final String evaluationFormArn() {
        return this.evaluationFormArn;
    }

    public final String evaluationFormId() {
        return this.evaluationFormId;
    }

    public final Integer evaluationFormVersion() {
        return this.evaluationFormVersion;
    }

    public final Boolean locked() {
        return this.locked;
    }

    public final EvaluationFormVersionStatus status() {
        return EvaluationFormVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locked());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormVersionSummary)) {
            return false;
        }
        EvaluationFormVersionSummary other = (EvaluationFormVersionSummary)obj;
        return Objects.equals(this.evaluationFormArn(), other.evaluationFormArn()) && Objects.equals(this.evaluationFormId(), other.evaluationFormId()) && Objects.equals(this.evaluationFormVersion(), other.evaluationFormVersion()) && Objects.equals(this.locked(), other.locked()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormVersionSummary").add("EvaluationFormArn", (Object)this.evaluationFormArn()).add("EvaluationFormId", (Object)this.evaluationFormId()).add("EvaluationFormVersion", (Object)this.evaluationFormVersion()).add("Locked", (Object)this.locked()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationFormArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormArn()));
            }
            case "EvaluationFormId": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormId()));
            }
            case "EvaluationFormVersion": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormVersion()));
            }
            case "Locked": {
                return Optional.ofNullable(clazz.cast(this.locked()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormVersionSummary, T> g) {
        return obj -> g.apply((EvaluationFormVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationFormArn;
        private String evaluationFormId;
        private Integer evaluationFormVersion;
        private Boolean locked;
        private String status;
        private Instant createdTime;
        private String createdBy;
        private Instant lastModifiedTime;
        private String lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormVersionSummary model) {
            this.evaluationFormArn(model.evaluationFormArn);
            this.evaluationFormId(model.evaluationFormId);
            this.evaluationFormVersion(model.evaluationFormVersion);
            this.locked(model.locked);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
        }

        public final String getEvaluationFormArn() {
            return this.evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getEvaluationFormId() {
            return this.evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return this.evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final Boolean getLocked() {
            return this.locked;
        }

        public final void setLocked(Boolean locked) {
            this.locked = locked;
        }

        @Override
        public final Builder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationFormVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public EvaluationFormVersionSummary build() {
            return new EvaluationFormVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormVersionSummary> {
        public Builder evaluationFormArn(String var1);

        public Builder evaluationFormId(String var1);

        public Builder evaluationFormVersion(Integer var1);

        public Builder locked(Boolean var1);

        public Builder status(String var1);

        public Builder status(EvaluationFormVersionStatus var1);

        public Builder createdTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(String var1);
    }
}

