/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchUsersRequest;
import software.amazon.awssdk.services.connect.model.SearchUsersResponse;
import software.amazon.awssdk.services.connect.model.UserSearchSummary;

public class SearchUsersIterable
implements SdkIterable<SearchUsersResponse> {
    private final ConnectClient client;
    private final SearchUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchUsersIterable(ConnectClient client, SearchUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchUsersResponseFetcher();
    }

    public Iterator<SearchUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserSearchSummary> users() {
        Function<SearchUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchUsersResponseFetcher
    implements SyncPageFetcher<SearchUsersResponse> {
        private SearchUsersResponseFetcher() {
        }

        public boolean hasNextPage(SearchUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchUsersResponse nextPage(SearchUsersResponse previousPage) {
            if (previousPage == null) {
                return SearchUsersIterable.this.client.searchUsers(SearchUsersIterable.this.firstRequest);
            }
            return SearchUsersIterable.this.client.searchUsers((SearchUsersRequest)((Object)SearchUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

