/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;

public class ListQuickConnectsPublisher
implements SdkPublisher<ListQuickConnectsResponse> {
    private final ConnectAsyncClient client;
    private final ListQuickConnectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQuickConnectsPublisher(ConnectAsyncClient client, ListQuickConnectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQuickConnectsPublisher(ConnectAsyncClient client, ListQuickConnectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQuickConnectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQuickConnectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QuickConnectSummary> quickConnectSummaryList() {
        Function<ListQuickConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickConnectSummaryList() != null) {
                return response.quickConnectSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQuickConnectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQuickConnectsResponseFetcher
    implements AsyncPageFetcher<ListQuickConnectsResponse> {
        private ListQuickConnectsResponseFetcher() {
        }

        public boolean hasNextPage(ListQuickConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQuickConnectsResponse> nextPage(ListQuickConnectsResponse previousPage) {
            if (previousPage == null) {
                return ListQuickConnectsPublisher.this.client.listQuickConnects(ListQuickConnectsPublisher.this.firstRequest);
            }
            return ListQuickConnectsPublisher.this.client.listQuickConnects((ListQuickConnectsRequest)((Object)ListQuickConnectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

