/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse;

public class ListContactFlowModulesIterable
implements SdkIterable<ListContactFlowModulesResponse> {
    private final ConnectClient client;
    private final ListContactFlowModulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactFlowModulesIterable(ConnectClient client, ListContactFlowModulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListContactFlowModulesResponseFetcher();
    }

    public Iterator<ListContactFlowModulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlowModuleSummary> contactFlowModulesSummaryList() {
        Function<ListContactFlowModulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModulesSummaryList() != null) {
                return response.contactFlowModulesSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactFlowModulesResponseFetcher
    implements SyncPageFetcher<ListContactFlowModulesResponse> {
        private ListContactFlowModulesResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowModulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactFlowModulesResponse nextPage(ListContactFlowModulesResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowModulesIterable.this.client.listContactFlowModules(ListContactFlowModulesIterable.this.firstRequest);
            }
            return ListContactFlowModulesIterable.this.client.listContactFlowModules((ListContactFlowModulesRequest)((Object)ListContactFlowModulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

