/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.Queue;
import software.amazon.awssdk.services.connect.model.SearchQueuesRequest;
import software.amazon.awssdk.services.connect.model.SearchQueuesResponse;

public class SearchQueuesPublisher
implements SdkPublisher<SearchQueuesResponse> {
    private final ConnectAsyncClient client;
    private final SearchQueuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchQueuesPublisher(ConnectAsyncClient client, SearchQueuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchQueuesPublisher(ConnectAsyncClient client, SearchQueuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchQueuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchQueuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Queue> queues() {
        Function<SearchQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queues() != null) {
                return response.queues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchQueuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchQueuesResponseFetcher
    implements AsyncPageFetcher<SearchQueuesResponse> {
        private SearchQueuesResponseFetcher() {
        }

        public boolean hasNextPage(SearchQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchQueuesResponse> nextPage(SearchQueuesResponse previousPage) {
            if (previousPage == null) {
                return SearchQueuesPublisher.this.client.searchQueues(SearchQueuesPublisher.this.firstRequest);
            }
            return SearchQueuesPublisher.this.client.searchQueues((SearchQueuesRequest)((Object)SearchQueuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

