/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.HoursOfOperationConfig;
import software.amazon.awssdk.services.connect.model.HoursOfOperationConfigListCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HoursOfOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HoursOfOperation> {
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationId").getter(HoursOfOperation.getter(HoursOfOperation::hoursOfOperationId)).setter(HoursOfOperation.setter(Builder::hoursOfOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationArn").getter(HoursOfOperation.getter(HoursOfOperation::hoursOfOperationArn)).setter(HoursOfOperation.setter(Builder::hoursOfOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(HoursOfOperation.getter(HoursOfOperation::name)).setter(HoursOfOperation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(HoursOfOperation.getter(HoursOfOperation::description)).setter(HoursOfOperation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZone").getter(HoursOfOperation.getter(HoursOfOperation::timeZone)).setter(HoursOfOperation.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<List<HoursOfOperationConfig>> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Config").getter(HoursOfOperation.getter(HoursOfOperation::config)).setter(HoursOfOperation.setter(Builder::config)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(HoursOfOperation.getter(HoursOfOperation::tags)).setter(HoursOfOperation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATION_ID_FIELD, HOURS_OF_OPERATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TIME_ZONE_FIELD, CONFIG_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hoursOfOperationId;
    private final String hoursOfOperationArn;
    private final String name;
    private final String description;
    private final String timeZone;
    private final List<HoursOfOperationConfig> config;
    private final Map<String, String> tags;

    private HoursOfOperation(BuilderImpl builder) {
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.hoursOfOperationArn = builder.hoursOfOperationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.timeZone = builder.timeZone;
        this.config = builder.config;
        this.tags = builder.tags;
    }

    public final String hoursOfOperationId() {
        return this.hoursOfOperationId;
    }

    public final String hoursOfOperationArn() {
        return this.hoursOfOperationArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final boolean hasConfig() {
        return this.config != null && !(this.config instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperationConfig> config() {
        return this.config;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfig() ? this.config() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoursOfOperation)) {
            return false;
        }
        HoursOfOperation other = (HoursOfOperation)obj;
        return Objects.equals(this.hoursOfOperationId(), other.hoursOfOperationId()) && Objects.equals(this.hoursOfOperationArn(), other.hoursOfOperationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeZone(), other.timeZone()) && this.hasConfig() == other.hasConfig() && Objects.equals(this.config(), other.config()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"HoursOfOperation").add("HoursOfOperationId", (Object)this.hoursOfOperationId()).add("HoursOfOperationArn", (Object)this.hoursOfOperationArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TimeZone", (Object)this.timeZone()).add("Config", this.hasConfig() ? this.config() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HoursOfOperationId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationId()));
            }
            case "HoursOfOperationArn": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HoursOfOperation, T> g) {
        return obj -> g.apply((HoursOfOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hoursOfOperationId;
        private String hoursOfOperationArn;
        private String name;
        private String description;
        private String timeZone;
        private List<HoursOfOperationConfig> config = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HoursOfOperation model) {
            this.hoursOfOperationId(model.hoursOfOperationId);
            this.hoursOfOperationArn(model.hoursOfOperationArn);
            this.name(model.name);
            this.description(model.description);
            this.timeZone(model.timeZone);
            this.config(model.config);
            this.tags(model.tags);
        }

        public final String getHoursOfOperationId() {
            return this.hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getHoursOfOperationArn() {
            return this.hoursOfOperationArn;
        }

        public final void setHoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
        }

        @Override
        public final Builder hoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final List<HoursOfOperationConfig.Builder> getConfig() {
            List<HoursOfOperationConfig.Builder> result = HoursOfOperationConfigListCopier.copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfig(Collection<HoursOfOperationConfig.BuilderImpl> config) {
            this.config = HoursOfOperationConfigListCopier.copyFromBuilder(config);
        }

        @Override
        public final Builder config(Collection<HoursOfOperationConfig> config) {
            this.config = HoursOfOperationConfigListCopier.copy(config);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(HoursOfOperationConfig ... config) {
            this.config(Arrays.asList(config));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(Consumer<HoursOfOperationConfig.Builder> ... config) {
            this.config(Stream.of(config).map(c -> (HoursOfOperationConfig)((HoursOfOperationConfig.Builder)HoursOfOperationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public HoursOfOperation build() {
            return new HoursOfOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HoursOfOperation> {
        public Builder hoursOfOperationId(String var1);

        public Builder hoursOfOperationArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder timeZone(String var1);

        public Builder config(Collection<HoursOfOperationConfig> var1);

        public Builder config(HoursOfOperationConfig ... var1);

        public Builder config(Consumer<HoursOfOperationConfig.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

