/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.SecurityProfileSummary;
import software.amazon.awssdk.services.connect.model.SecurityProfileSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfilesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListSecurityProfilesResponse> {
    private static final SdkField<List<SecurityProfileSummary>> SECURITY_PROFILE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityProfileSummaryList").getter(ListSecurityProfilesResponse.getter(ListSecurityProfilesResponse::securityProfileSummaryList)).setter(ListSecurityProfilesResponse.setter(Builder::securityProfileSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSecurityProfilesResponse.getter(ListSecurityProfilesResponse::nextToken)).setter(ListSecurityProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<SecurityProfileSummary> securityProfileSummaryList;
    private final String nextToken;

    private ListSecurityProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileSummaryList = builder.securityProfileSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityProfileSummaryList() {
        return this.securityProfileSummaryList != null && !(this.securityProfileSummaryList instanceof SdkAutoConstructList);
    }

    public final List<SecurityProfileSummary> securityProfileSummaryList() {
        return this.securityProfileSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfileSummaryList() ? this.securityProfileSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesResponse)) {
            return false;
        }
        ListSecurityProfilesResponse other = (ListSecurityProfilesResponse)((Object)obj);
        return this.hasSecurityProfileSummaryList() == other.hasSecurityProfileSummaryList() && Objects.equals(this.securityProfileSummaryList(), other.securityProfileSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityProfilesResponse").add("SecurityProfileSummaryList", this.hasSecurityProfileSummaryList() ? this.securityProfileSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityProfileSummaryList": {
                return Optional.ofNullable(clazz.cast(this.securityProfileSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileSummary> securityProfileSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesResponse model) {
            super(model);
            this.securityProfileSummaryList(model.securityProfileSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityProfileSummary.Builder> getSecurityProfileSummaryList() {
            List<SecurityProfileSummary.Builder> result = SecurityProfileSummaryListCopier.copyToBuilder(this.securityProfileSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder securityProfileSummaryList(Collection<SecurityProfileSummary> securityProfileSummaryList) {
            this.securityProfileSummaryList = SecurityProfileSummaryListCopier.copy(securityProfileSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileSummaryList(SecurityProfileSummary ... securityProfileSummaryList) {
            this.securityProfileSummaryList(Arrays.asList(securityProfileSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileSummaryList(Consumer<SecurityProfileSummary.Builder> ... securityProfileSummaryList) {
            this.securityProfileSummaryList(Stream.of(securityProfileSummaryList).map(c -> (SecurityProfileSummary)((SecurityProfileSummary.Builder)SecurityProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileSummaryList(Collection<SecurityProfileSummary.BuilderImpl> securityProfileSummaryList) {
            this.securityProfileSummaryList = SecurityProfileSummaryListCopier.copyFromBuilder(securityProfileSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityProfilesResponse build() {
            return new ListSecurityProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityProfilesResponse> {
        public Builder securityProfileSummaryList(Collection<SecurityProfileSummary> var1);

        public Builder securityProfileSummaryList(SecurityProfileSummary ... var1);

        public Builder securityProfileSummaryList(Consumer<SecurityProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

