/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCode;
import software.amazon.awssdk.services.connect.model.PhoneNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumberSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumberSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(PhoneNumberSummary.getter(PhoneNumberSummary::id)).setter(PhoneNumberSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(PhoneNumberSummary.getter(PhoneNumberSummary::arn)).setter(PhoneNumberSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(PhoneNumberSummary.getter(PhoneNumberSummary::phoneNumber)).setter(PhoneNumberSummary.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberType").getter(PhoneNumberSummary.getter(PhoneNumberSummary::phoneNumberTypeAsString)).setter(PhoneNumberSummary.setter(Builder::phoneNumberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberCountryCode").getter(PhoneNumberSummary.getter(PhoneNumberSummary::phoneNumberCountryCodeAsString)).setter(PhoneNumberSummary.setter(Builder::phoneNumberCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBER_TYPE_FIELD, PHONE_NUMBER_COUNTRY_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String phoneNumber;
    private final String phoneNumberType;
    private final String phoneNumberCountryCode;

    private PhoneNumberSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumberType = builder.phoneNumberType;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(this.phoneNumberType);
    }

    public final String phoneNumberTypeAsString() {
        return this.phoneNumberType;
    }

    public final PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(this.phoneNumberCountryCode);
    }

    public final String phoneNumberCountryCodeAsString() {
        return this.phoneNumberCountryCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberCountryCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberSummary)) {
            return false;
        }
        PhoneNumberSummary other = (PhoneNumberSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.phoneNumberTypeAsString(), other.phoneNumberTypeAsString()) && Objects.equals(this.phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumberSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("PhoneNumber", (Object)this.phoneNumber()).add("PhoneNumberType", (Object)this.phoneNumberTypeAsString()).add("PhoneNumberCountryCode", (Object)this.phoneNumberCountryCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "PhoneNumberType": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypeAsString()));
            }
            case "PhoneNumberCountryCode": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountryCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberSummary, T> g) {
        return obj -> g.apply((PhoneNumberSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String phoneNumber;
        private String phoneNumberType;
        private String phoneNumberCountryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.phoneNumber(model.phoneNumber);
            this.phoneNumberType(model.phoneNumberType);
            this.phoneNumberCountryCode(model.phoneNumberCountryCode);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getPhoneNumberType() {
            return this.phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        public final String getPhoneNumberCountryCode() {
            return this.phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        public PhoneNumberSummary build() {
            return new PhoneNumberSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumberSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder phoneNumber(String var1);

        public Builder phoneNumberType(String var1);

        public Builder phoneNumberType(PhoneNumberType var1);

        public Builder phoneNumberCountryCode(String var1);

        public Builder phoneNumberCountryCode(PhoneNumberCountryCode var1);
    }
}

