/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.InstanceStorageConfig;
import software.amazon.awssdk.services.connect.model.InstanceStorageConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceStorageConfigsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListInstanceStorageConfigsResponse> {
    private static final SdkField<List<InstanceStorageConfig>> STORAGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageConfigs").getter(ListInstanceStorageConfigsResponse.getter(ListInstanceStorageConfigsResponse::storageConfigs)).setter(ListInstanceStorageConfigsResponse.setter(Builder::storageConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInstanceStorageConfigsResponse.getter(ListInstanceStorageConfigsResponse::nextToken)).setter(ListInstanceStorageConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceStorageConfig> storageConfigs;
    private final String nextToken;

    private ListInstanceStorageConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.storageConfigs = builder.storageConfigs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStorageConfigs() {
        return this.storageConfigs != null && !(this.storageConfigs instanceof SdkAutoConstructList);
    }

    public final List<InstanceStorageConfig> storageConfigs() {
        return this.storageConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConfigs() ? this.storageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceStorageConfigsResponse)) {
            return false;
        }
        ListInstanceStorageConfigsResponse other = (ListInstanceStorageConfigsResponse)((Object)obj);
        return this.hasStorageConfigs() == other.hasStorageConfigs() && Objects.equals(this.storageConfigs(), other.storageConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstanceStorageConfigsResponse").add("StorageConfigs", this.hasStorageConfigs() ? this.storageConfigs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageConfigs": {
                return Optional.ofNullable(clazz.cast(this.storageConfigs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceStorageConfigsResponse, T> g) {
        return obj -> g.apply((ListInstanceStorageConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<InstanceStorageConfig> storageConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceStorageConfigsResponse model) {
            super(model);
            this.storageConfigs(model.storageConfigs);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceStorageConfig.Builder> getStorageConfigs() {
            if (this.storageConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storageConfigs != null ? (Collection)this.storageConfigs.stream().map(InstanceStorageConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConfigs(Collection<InstanceStorageConfig> storageConfigs) {
            this.storageConfigs = InstanceStorageConfigsCopier.copy(storageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigs(InstanceStorageConfig ... storageConfigs) {
            this.storageConfigs(Arrays.asList(storageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigs(Consumer<InstanceStorageConfig.Builder> ... storageConfigs) {
            this.storageConfigs(Stream.of(storageConfigs).map(c -> (InstanceStorageConfig)((InstanceStorageConfig.Builder)InstanceStorageConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConfigs(Collection<InstanceStorageConfig.BuilderImpl> storageConfigs) {
            this.storageConfigs = InstanceStorageConfigsCopier.copyFromBuilder(storageConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstanceStorageConfigsResponse build() {
            return new ListInstanceStorageConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstanceStorageConfigsResponse> {
        public Builder storageConfigs(Collection<InstanceStorageConfig> var1);

        public Builder storageConfigs(InstanceStorageConfig ... var1);

        public Builder storageConfigs(Consumer<InstanceStorageConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

