/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.InstanceStorageConfig;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse;

public class ListInstanceStorageConfigsPublisher
implements SdkPublisher<ListInstanceStorageConfigsResponse> {
    private final ConnectAsyncClient client;
    private final ListInstanceStorageConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceStorageConfigsPublisher(ConnectAsyncClient client, ListInstanceStorageConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceStorageConfigsPublisher(ConnectAsyncClient client, ListInstanceStorageConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceStorageConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceStorageConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceStorageConfig> storageConfigs() {
        Function<ListInstanceStorageConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageConfigs() != null) {
                return response.storageConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceStorageConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInstanceStorageConfigsResponseFetcher
    implements AsyncPageFetcher<ListInstanceStorageConfigsResponse> {
        private ListInstanceStorageConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceStorageConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInstanceStorageConfigsResponse> nextPage(ListInstanceStorageConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceStorageConfigsPublisher.this.client.listInstanceStorageConfigs(ListInstanceStorageConfigsPublisher.this.firstRequest);
            }
            return ListInstanceStorageConfigsPublisher.this.client.listInstanceStorageConfigs((ListInstanceStorageConfigsRequest)((Object)ListInstanceStorageConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

