/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HierarchyGroupSummary;
import software.amazon.awssdk.services.connect.model.HierarchyGroupSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserHierarchyGroupsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListUserHierarchyGroupsResponse> {
    private static final SdkField<List<HierarchyGroupSummary>> USER_HIERARCHY_GROUP_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserHierarchyGroupSummaryList").getter(ListUserHierarchyGroupsResponse.getter(ListUserHierarchyGroupsResponse::userHierarchyGroupSummaryList)).setter(ListUserHierarchyGroupsResponse.setter(Builder::userHierarchyGroupSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserHierarchyGroupSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HierarchyGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUserHierarchyGroupsResponse.getter(ListUserHierarchyGroupsResponse::nextToken)).setter(ListUserHierarchyGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_HIERARCHY_GROUP_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<HierarchyGroupSummary> userHierarchyGroupSummaryList;
    private final String nextToken;

    private ListUserHierarchyGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.userHierarchyGroupSummaryList = builder.userHierarchyGroupSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserHierarchyGroupSummaryList() {
        return this.userHierarchyGroupSummaryList != null && !(this.userHierarchyGroupSummaryList instanceof SdkAutoConstructList);
    }

    public final List<HierarchyGroupSummary> userHierarchyGroupSummaryList() {
        return this.userHierarchyGroupSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserHierarchyGroupSummaryList() ? this.userHierarchyGroupSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserHierarchyGroupsResponse)) {
            return false;
        }
        ListUserHierarchyGroupsResponse other = (ListUserHierarchyGroupsResponse)((Object)obj);
        return this.hasUserHierarchyGroupSummaryList() == other.hasUserHierarchyGroupSummaryList() && Objects.equals(this.userHierarchyGroupSummaryList(), other.userHierarchyGroupSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserHierarchyGroupsResponse").add("UserHierarchyGroupSummaryList", this.hasUserHierarchyGroupSummaryList() ? this.userHierarchyGroupSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserHierarchyGroupSummaryList": {
                return Optional.ofNullable(clazz.cast(this.userHierarchyGroupSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserHierarchyGroupsResponse, T> g) {
        return obj -> g.apply((ListUserHierarchyGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<HierarchyGroupSummary> userHierarchyGroupSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserHierarchyGroupsResponse model) {
            super(model);
            this.userHierarchyGroupSummaryList(model.userHierarchyGroupSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<HierarchyGroupSummary.Builder> getUserHierarchyGroupSummaryList() {
            if (this.userHierarchyGroupSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userHierarchyGroupSummaryList != null ? (Collection)this.userHierarchyGroupSummaryList.stream().map(HierarchyGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userHierarchyGroupSummaryList(Collection<HierarchyGroupSummary> userHierarchyGroupSummaryList) {
            this.userHierarchyGroupSummaryList = HierarchyGroupSummaryListCopier.copy(userHierarchyGroupSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroupSummaryList(HierarchyGroupSummary ... userHierarchyGroupSummaryList) {
            this.userHierarchyGroupSummaryList(Arrays.asList(userHierarchyGroupSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroupSummaryList(Consumer<HierarchyGroupSummary.Builder> ... userHierarchyGroupSummaryList) {
            this.userHierarchyGroupSummaryList(Stream.of(userHierarchyGroupSummaryList).map(c -> (HierarchyGroupSummary)((HierarchyGroupSummary.Builder)HierarchyGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserHierarchyGroupSummaryList(Collection<HierarchyGroupSummary.BuilderImpl> userHierarchyGroupSummaryList) {
            this.userHierarchyGroupSummaryList = HierarchyGroupSummaryListCopier.copyFromBuilder(userHierarchyGroupSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserHierarchyGroupsResponse build() {
            return new ListUserHierarchyGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserHierarchyGroupsResponse> {
        public Builder userHierarchyGroupSummaryList(Collection<HierarchyGroupSummary> var1);

        public Builder userHierarchyGroupSummaryList(HierarchyGroupSummary ... var1);

        public Builder userHierarchyGroupSummaryList(Consumer<HierarchyGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

