/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.SecurityKey;
import software.amazon.awssdk.services.connect.model.SecurityKeysListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityKeysResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListSecurityKeysResponse> {
    private static final SdkField<List<SecurityKey>> SECURITY_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityKeys").getter(ListSecurityKeysResponse.getter(ListSecurityKeysResponse::securityKeys)).setter(ListSecurityKeysResponse.setter(Builder::securityKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSecurityKeysResponse.getter(ListSecurityKeysResponse::nextToken)).setter(ListSecurityKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_KEYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SecurityKey> securityKeys;
    private final String nextToken;

    private ListSecurityKeysResponse(BuilderImpl builder) {
        super(builder);
        this.securityKeys = builder.securityKeys;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSecurityKeys() {
        return this.securityKeys != null && !(this.securityKeys instanceof SdkAutoConstructList);
    }

    public List<SecurityKey> securityKeys() {
        return this.securityKeys;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityKeys() ? this.securityKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityKeysResponse)) {
            return false;
        }
        ListSecurityKeysResponse other = (ListSecurityKeysResponse)((Object)obj);
        return this.hasSecurityKeys() == other.hasSecurityKeys() && Objects.equals(this.securityKeys(), other.securityKeys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSecurityKeysResponse").add("SecurityKeys", this.hasSecurityKeys() ? this.securityKeys() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityKeys": {
                return Optional.ofNullable(clazz.cast(this.securityKeys()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityKeysResponse, T> g) {
        return obj -> g.apply((ListSecurityKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<SecurityKey> securityKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityKeysResponse model) {
            super(model);
            this.securityKeys(model.securityKeys);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityKey.Builder> getSecurityKeys() {
            if (this.securityKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityKeys != null ? (Collection)this.securityKeys.stream().map(SecurityKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityKeys(Collection<SecurityKey> securityKeys) {
            this.securityKeys = SecurityKeysListCopier.copy(securityKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityKeys(SecurityKey ... securityKeys) {
            this.securityKeys(Arrays.asList(securityKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityKeys(Consumer<SecurityKey.Builder> ... securityKeys) {
            this.securityKeys(Stream.of(securityKeys).map(c -> (SecurityKey)((SecurityKey.Builder)SecurityKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityKeys(Collection<SecurityKey.BuilderImpl> securityKeys) {
            this.securityKeys = SecurityKeysListCopier.copyFromBuilder(securityKeys);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityKeysResponse build() {
            return new ListSecurityKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityKeysResponse> {
        public Builder securityKeys(Collection<SecurityKey> var1);

        public Builder securityKeys(SecurityKey ... var1);

        public Builder securityKeys(Consumer<SecurityKey.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

