/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingProfileQueueReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingProfileQueueReference> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(RoutingProfileQueueReference.getter(RoutingProfileQueueReference::queueId)).setter(RoutingProfileQueueReference.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(RoutingProfileQueueReference.getter(RoutingProfileQueueReference::channelAsString)).setter(RoutingProfileQueueReference.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, CHANNEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queueId;
    private final String channel;

    private RoutingProfileQueueReference(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.channel = builder.channel;
    }

    public String queueId() {
        return this.queueId;
    }

    public Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public String channelAsString() {
        return this.channel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileQueueReference)) {
            return false;
        }
        RoutingProfileQueueReference other = (RoutingProfileQueueReference)obj;
        return Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.channelAsString(), other.channelAsString());
    }

    public String toString() {
        return ToString.builder((String)"RoutingProfileQueueReference").add("QueueId", (Object)this.queueId()).add("Channel", (Object)this.channelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileQueueReference, T> g) {
        return obj -> g.apply((RoutingProfileQueueReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queueId;
        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileQueueReference model) {
            this.queueId(model.queueId);
            this.channel(model.channel);
        }

        public final String getQueueId() {
            return this.queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        public final String getChannel() {
            return this.channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        public RoutingProfileQueueReference build() {
            return new RoutingProfileQueueReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingProfileQueueReference> {
        public Builder queueId(String var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);
    }
}

