/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.IntegrationType;
import software.amazon.awssdk.services.connect.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegrationAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegrationAssociationSummary> {
    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationAssociationId").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::integrationAssociationId)).setter(IntegrationAssociationSummary.setter(Builder::integrationAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationId").build()}).build();
    private static final SdkField<String> INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationAssociationArn").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::integrationAssociationArn)).setter(IntegrationAssociationSummary.setter(Builder::integrationAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationArn").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::instanceId)).setter(IntegrationAssociationSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationType").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::integrationTypeAsString)).setter(IntegrationAssociationSummary.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationType").build()}).build();
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationArn").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::integrationArn)).setter(IntegrationAssociationSummary.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()}).build();
    private static final SdkField<String> SOURCE_APPLICATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceApplicationUrl").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::sourceApplicationUrl)).setter(IntegrationAssociationSummary.setter(Builder::sourceApplicationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationUrl").build()}).build();
    private static final SdkField<String> SOURCE_APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceApplicationName").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::sourceApplicationName)).setter(IntegrationAssociationSummary.setter(Builder::sourceApplicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceApplicationName").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(IntegrationAssociationSummary.getter(IntegrationAssociationSummary::sourceTypeAsString)).setter(IntegrationAssociationSummary.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ASSOCIATION_ID_FIELD, INTEGRATION_ASSOCIATION_ARN_FIELD, INSTANCE_ID_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_ARN_FIELD, SOURCE_APPLICATION_URL_FIELD, SOURCE_APPLICATION_NAME_FIELD, SOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String integrationAssociationId;
    private final String integrationAssociationArn;
    private final String instanceId;
    private final String integrationType;
    private final String integrationArn;
    private final String sourceApplicationUrl;
    private final String sourceApplicationName;
    private final String sourceType;

    private IntegrationAssociationSummary(BuilderImpl builder) {
        this.integrationAssociationId = builder.integrationAssociationId;
        this.integrationAssociationArn = builder.integrationAssociationArn;
        this.instanceId = builder.instanceId;
        this.integrationType = builder.integrationType;
        this.integrationArn = builder.integrationArn;
        this.sourceApplicationUrl = builder.sourceApplicationUrl;
        this.sourceApplicationName = builder.sourceApplicationName;
        this.sourceType = builder.sourceType;
    }

    public String integrationAssociationId() {
        return this.integrationAssociationId;
    }

    public String integrationAssociationArn() {
        return this.integrationAssociationArn;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public String integrationTypeAsString() {
        return this.integrationType;
    }

    public String integrationArn() {
        return this.integrationArn;
    }

    public String sourceApplicationUrl() {
        return this.sourceApplicationUrl;
    }

    public String sourceApplicationName() {
        return this.sourceApplicationName;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApplicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationAssociationSummary)) {
            return false;
        }
        IntegrationAssociationSummary other = (IntegrationAssociationSummary)obj;
        return Objects.equals(this.integrationAssociationId(), other.integrationAssociationId()) && Objects.equals(this.integrationAssociationArn(), other.integrationAssociationArn()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString()) && Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.sourceApplicationUrl(), other.sourceApplicationUrl()) && Objects.equals(this.sourceApplicationName(), other.sourceApplicationName()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"IntegrationAssociationSummary").add("IntegrationAssociationId", (Object)this.integrationAssociationId()).add("IntegrationAssociationArn", (Object)this.integrationAssociationArn()).add("InstanceId", (Object)this.instanceId()).add("IntegrationType", (Object)this.integrationTypeAsString()).add("IntegrationArn", (Object)this.integrationArn()).add("SourceApplicationUrl", (Object)this.sourceApplicationUrl()).add("SourceApplicationName", (Object)this.sourceApplicationName()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationAssociationId": {
                return Optional.ofNullable(clazz.cast(this.integrationAssociationId()));
            }
            case "IntegrationAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationAssociationArn()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "IntegrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
            case "IntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "SourceApplicationUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceApplicationUrl()));
            }
            case "SourceApplicationName": {
                return Optional.ofNullable(clazz.cast(this.sourceApplicationName()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegrationAssociationSummary, T> g) {
        return obj -> g.apply((IntegrationAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String integrationAssociationId;
        private String integrationAssociationArn;
        private String instanceId;
        private String integrationType;
        private String integrationArn;
        private String sourceApplicationUrl;
        private String sourceApplicationName;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationAssociationSummary model) {
            this.integrationAssociationId(model.integrationAssociationId);
            this.integrationAssociationArn(model.integrationAssociationArn);
            this.instanceId(model.instanceId);
            this.integrationType(model.integrationType);
            this.integrationArn(model.integrationArn);
            this.sourceApplicationUrl(model.sourceApplicationUrl);
            this.sourceApplicationName(model.sourceApplicationName);
            this.sourceType(model.sourceType);
        }

        public final String getIntegrationAssociationId() {
            return this.integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        public final String getIntegrationAssociationArn() {
            return this.integrationAssociationArn;
        }

        @Override
        public final Builder integrationAssociationArn(String integrationAssociationArn) {
            this.integrationAssociationArn = integrationAssociationArn;
            return this;
        }

        public final void setIntegrationAssociationArn(String integrationAssociationArn) {
            this.integrationAssociationArn = integrationAssociationArn;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        public final String getSourceApplicationUrl() {
            return this.sourceApplicationUrl;
        }

        @Override
        public final Builder sourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
            return this;
        }

        public final void setSourceApplicationUrl(String sourceApplicationUrl) {
            this.sourceApplicationUrl = sourceApplicationUrl;
        }

        public final String getSourceApplicationName() {
            return this.sourceApplicationName;
        }

        @Override
        public final Builder sourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
            return this;
        }

        public final void setSourceApplicationName(String sourceApplicationName) {
            this.sourceApplicationName = sourceApplicationName;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public IntegrationAssociationSummary build() {
            return new IntegrationAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegrationAssociationSummary> {
        public Builder integrationAssociationId(String var1);

        public Builder integrationAssociationArn(String var1);

        public Builder instanceId(String var1);

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder integrationArn(String var1);

        public Builder sourceApplicationUrl(String var1);

        public Builder sourceApplicationName(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);
    }
}

