/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.MediaConcurrenciesCopier;
import software.amazon.awssdk.services.connect.model.MediaConcurrency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoutingProfileConcurrencyRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateRoutingProfileConcurrencyRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateRoutingProfileConcurrencyRequest.getter(UpdateRoutingProfileConcurrencyRequest::instanceId)).setter(UpdateRoutingProfileConcurrencyRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(UpdateRoutingProfileConcurrencyRequest.getter(UpdateRoutingProfileConcurrencyRequest::routingProfileId)).setter(UpdateRoutingProfileConcurrencyRequest.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConcurrencies").getter(UpdateRoutingProfileConcurrencyRequest.getter(UpdateRoutingProfileConcurrencyRequest::mediaConcurrencies)).setter(UpdateRoutingProfileConcurrencyRequest.setter(Builder::mediaConcurrencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConcurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ROUTING_PROFILE_ID_FIELD, MEDIA_CONCURRENCIES_FIELD));
    private final String instanceId;
    private final String routingProfileId;
    private final List<MediaConcurrency> mediaConcurrencies;

    private UpdateRoutingProfileConcurrencyRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.mediaConcurrencies = builder.mediaConcurrencies;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String routingProfileId() {
        return this.routingProfileId;
    }

    public boolean hasMediaConcurrencies() {
        return this.mediaConcurrencies != null && !(this.mediaConcurrencies instanceof SdkAutoConstructList);
    }

    public List<MediaConcurrency> mediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaConcurrencies() ? this.mediaConcurrencies() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileConcurrencyRequest)) {
            return false;
        }
        UpdateRoutingProfileConcurrencyRequest other = (UpdateRoutingProfileConcurrencyRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && this.hasMediaConcurrencies() == other.hasMediaConcurrencies() && Objects.equals(this.mediaConcurrencies(), other.mediaConcurrencies());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRoutingProfileConcurrencyRequest").add("InstanceId", (Object)this.instanceId()).add("RoutingProfileId", (Object)this.routingProfileId()).add("MediaConcurrencies", this.hasMediaConcurrencies() ? this.mediaConcurrencies() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "MediaConcurrencies": {
                return Optional.ofNullable(clazz.cast(this.mediaConcurrencies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingProfileConcurrencyRequest, T> g) {
        return obj -> g.apply((UpdateRoutingProfileConcurrencyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String routingProfileId;
        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingProfileConcurrencyRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.routingProfileId(model.routingProfileId);
            this.mediaConcurrencies(model.mediaConcurrencies);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final Collection<MediaConcurrency.Builder> getMediaConcurrencies() {
            if (this.mediaConcurrencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mediaConcurrencies != null ? (Collection)this.mediaConcurrencies.stream().map(MediaConcurrency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
            this.mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... mediaConcurrencies) {
            this.mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> (MediaConcurrency)((MediaConcurrency.Builder)MediaConcurrency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingProfileConcurrencyRequest build() {
            return new UpdateRoutingProfileConcurrencyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoutingProfileConcurrencyRequest> {
        public Builder instanceId(String var1);

        public Builder routingProfileId(String var1);

        public Builder mediaConcurrencies(Collection<MediaConcurrency> var1);

        public Builder mediaConcurrencies(MediaConcurrency ... var1);

        public Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

