/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.UserPhoneConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserPhoneConfigRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateUserPhoneConfigRequest> {
    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhoneConfig").getter(UpdateUserPhoneConfigRequest.getter(UpdateUserPhoneConfigRequest::phoneConfig)).setter(UpdateUserPhoneConfigRequest.setter(Builder::phoneConfig)).constructor(UserPhoneConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserPhoneConfigRequest.getter(UpdateUserPhoneConfigRequest::userId)).setter(UpdateUserPhoneConfigRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateUserPhoneConfigRequest.getter(UpdateUserPhoneConfigRequest::instanceId)).setter(UpdateUserPhoneConfigRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_CONFIG_FIELD, USER_ID_FIELD, INSTANCE_ID_FIELD));
    private final UserPhoneConfig phoneConfig;
    private final String userId;
    private final String instanceId;

    private UpdateUserPhoneConfigRequest(BuilderImpl builder) {
        super(builder);
        this.phoneConfig = builder.phoneConfig;
        this.userId = builder.userId;
        this.instanceId = builder.instanceId;
    }

    public UserPhoneConfig phoneConfig() {
        return this.phoneConfig;
    }

    public String userId() {
        return this.userId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPhoneConfigRequest)) {
            return false;
        }
        UpdateUserPhoneConfigRequest other = (UpdateUserPhoneConfigRequest)((Object)obj);
        return Objects.equals(this.phoneConfig(), other.phoneConfig()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserPhoneConfigRequest").add("PhoneConfig", (Object)this.phoneConfig()).add("UserId", (Object)this.userId()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneConfig": {
                return Optional.ofNullable(clazz.cast(this.phoneConfig()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPhoneConfigRequest, T> g) {
        return obj -> g.apply((UpdateUserPhoneConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private UserPhoneConfig phoneConfig;
        private String userId;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPhoneConfigRequest model) {
            super(model);
            this.phoneConfig(model.phoneConfig);
            this.userId(model.userId);
            this.instanceId(model.instanceId);
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return this.phoneConfig != null ? this.phoneConfig.toBuilder() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPhoneConfigRequest build() {
            return new UpdateUserPhoneConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserPhoneConfigRequest> {
        public Builder phoneConfig(UserPhoneConfig var1);

        default public Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return this.phoneConfig((UserPhoneConfig)((UserPhoneConfig.Builder)UserPhoneConfig.builder().applyMutation(phoneConfig)).build());
        }

        public Builder userId(String var1);

        public Builder instanceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

