/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.QueueSummary;
import software.amazon.awssdk.services.connect.model.QueueSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListQueuesResponse> {
    private static final SdkField<List<QueueSummary>> QUEUE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueSummaryList").getter(ListQueuesResponse.getter(ListQueuesResponse::queueSummaryList)).setter(ListQueuesResponse.setter(Builder::queueSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQueuesResponse.getter(ListQueuesResponse::nextToken)).setter(ListQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<QueueSummary> queueSummaryList;
    private final String nextToken;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueSummaryList = builder.queueSummaryList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasQueueSummaryList() {
        return this.queueSummaryList != null && !(this.queueSummaryList instanceof SdkAutoConstructList);
    }

    public List<QueueSummary> queueSummaryList() {
        return this.queueSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse)((Object)obj);
        return Objects.equals(this.queueSummaryList(), other.queueSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListQueuesResponse").add("QueueSummaryList", this.queueSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueSummaryList": {
                return Optional.ofNullable(clazz.cast(this.queueSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<QueueSummary> queueSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            this.queueSummaryList(model.queueSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<QueueSummary.Builder> getQueueSummaryList() {
            return this.queueSummaryList != null ? (Collection)this.queueSummaryList.stream().map(QueueSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueSummaryList(Collection<QueueSummary> queueSummaryList) {
            this.queueSummaryList = QueueSummaryListCopier.copy(queueSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueSummaryList(QueueSummary ... queueSummaryList) {
            this.queueSummaryList(Arrays.asList(queueSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueSummaryList(Consumer<QueueSummary.Builder> ... queueSummaryList) {
            this.queueSummaryList(Stream.of(queueSummaryList).map(c -> (QueueSummary)((QueueSummary.Builder)QueueSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueueSummaryList(Collection<QueueSummary.BuilderImpl> queueSummaryList) {
            this.queueSummaryList = QueueSummaryListCopier.copyFromBuilder(queueSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueuesResponse> {
        public Builder queueSummaryList(Collection<QueueSummary> var1);

        public Builder queueSummaryList(QueueSummary ... var1);

        public Builder queueSummaryList(Consumer<QueueSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

