/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.MediaConcurrenciesCopier;
import software.amazon.awssdk.services.connect.model.MediaConcurrency;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigListCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoutingProfileRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateRoutingProfileRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::instanceId)).setter(CreateRoutingProfileRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::name)).setter(CreateRoutingProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::description)).setter(CreateRoutingProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultOutboundQueueId").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::defaultOutboundQueueId)).setter(CreateRoutingProfileRequest.setter(Builder::defaultOutboundQueueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build()}).build();
    private static final SdkField<List<RoutingProfileQueueConfig>> QUEUE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueConfigs").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::queueConfigs)).setter(CreateRoutingProfileRequest.setter(Builder::queueConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileQueueConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConcurrencies").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::mediaConcurrencies)).setter(CreateRoutingProfileRequest.setter(Builder::mediaConcurrencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConcurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRoutingProfileRequest.getter(CreateRoutingProfileRequest::tags)).setter(CreateRoutingProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_OUTBOUND_QUEUE_ID_FIELD, QUEUE_CONFIGS_FIELD, MEDIA_CONCURRENCIES_FIELD, TAGS_FIELD));
    private final String instanceId;
    private final String name;
    private final String description;
    private final String defaultOutboundQueueId;
    private final List<RoutingProfileQueueConfig> queueConfigs;
    private final List<MediaConcurrency> mediaConcurrencies;
    private final Map<String, String> tags;

    private CreateRoutingProfileRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
        this.queueConfigs = builder.queueConfigs;
        this.mediaConcurrencies = builder.mediaConcurrencies;
        this.tags = builder.tags;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String defaultOutboundQueueId() {
        return this.defaultOutboundQueueId;
    }

    public boolean hasQueueConfigs() {
        return this.queueConfigs != null && !(this.queueConfigs instanceof SdkAutoConstructList);
    }

    public List<RoutingProfileQueueConfig> queueConfigs() {
        return this.queueConfigs;
    }

    public boolean hasMediaConcurrencies() {
        return this.mediaConcurrencies != null && !(this.mediaConcurrencies instanceof SdkAutoConstructList);
    }

    public List<MediaConcurrency> mediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOutboundQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConcurrencies());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoutingProfileRequest)) {
            return false;
        }
        CreateRoutingProfileRequest other = (CreateRoutingProfileRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultOutboundQueueId(), other.defaultOutboundQueueId()) && Objects.equals(this.queueConfigs(), other.queueConfigs()) && Objects.equals(this.mediaConcurrencies(), other.mediaConcurrencies()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateRoutingProfileRequest").add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DefaultOutboundQueueId", (Object)this.defaultOutboundQueueId()).add("QueueConfigs", this.queueConfigs()).add("MediaConcurrencies", this.mediaConcurrencies()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultOutboundQueueId": {
                return Optional.ofNullable(clazz.cast(this.defaultOutboundQueueId()));
            }
            case "QueueConfigs": {
                return Optional.ofNullable(clazz.cast(this.queueConfigs()));
            }
            case "MediaConcurrencies": {
                return Optional.ofNullable(clazz.cast(this.mediaConcurrencies()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoutingProfileRequest, T> g) {
        return obj -> g.apply((CreateRoutingProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String name;
        private String description;
        private String defaultOutboundQueueId;
        private List<RoutingProfileQueueConfig> queueConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoutingProfileRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.description(model.description);
            this.defaultOutboundQueueId(model.defaultOutboundQueueId);
            this.queueConfigs(model.queueConfigs);
            this.mediaConcurrencies(model.mediaConcurrencies);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultOutboundQueueId() {
            return this.defaultOutboundQueueId;
        }

        @Override
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        public final Collection<RoutingProfileQueueConfig.Builder> getQueueConfigs() {
            return this.queueConfigs != null ? (Collection)this.queueConfigs.stream().map(RoutingProfileQueueConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copy(queueConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(RoutingProfileQueueConfig ... queueConfigs) {
            this.queueConfigs(Arrays.asList(queueConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder> ... queueConfigs) {
            this.queueConfigs(Stream.of(queueConfigs).map(c -> (RoutingProfileQueueConfig)((RoutingProfileQueueConfig.Builder)RoutingProfileQueueConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueueConfigs(Collection<RoutingProfileQueueConfig.BuilderImpl> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copyFromBuilder(queueConfigs);
        }

        public final Collection<MediaConcurrency.Builder> getMediaConcurrencies() {
            return this.mediaConcurrencies != null ? (Collection)this.mediaConcurrencies.stream().map(MediaConcurrency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
            this.mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... mediaConcurrencies) {
            this.mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> (MediaConcurrency)((MediaConcurrency.Builder)MediaConcurrency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoutingProfileRequest build() {
            return new CreateRoutingProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoutingProfileRequest> {
        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder defaultOutboundQueueId(String var1);

        public Builder queueConfigs(Collection<RoutingProfileQueueConfig> var1);

        public Builder queueConfigs(RoutingProfileQueueConfig ... var1);

        public Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder> ... var1);

        public Builder mediaConcurrencies(Collection<MediaConcurrency> var1);

        public Builder mediaConcurrencies(MediaConcurrency ... var1);

        public Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

