/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingProfileQueueConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingProfileQueueConfigSummary> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoutingProfileQueueConfigSummary.getter(RoutingProfileQueueConfigSummary::queueId)).setter(RoutingProfileQueueConfigSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoutingProfileQueueConfigSummary.getter(RoutingProfileQueueConfigSummary::queueArn)).setter(RoutingProfileQueueConfigSummary.setter(Builder::queueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()}).build();
    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoutingProfileQueueConfigSummary.getter(RoutingProfileQueueConfigSummary::queueName)).setter(RoutingProfileQueueConfigSummary.setter(Builder::queueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RoutingProfileQueueConfigSummary.getter(RoutingProfileQueueConfigSummary::priority)).setter(RoutingProfileQueueConfigSummary.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<Integer> DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RoutingProfileQueueConfigSummary.getter(RoutingProfileQueueConfigSummary::delay)).setter(RoutingProfileQueueConfigSummary.setter(Builder::delay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delay").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoutingProfileQueueConfigSummary.getter(RoutingProfileQueueConfigSummary::channelAsString)).setter(RoutingProfileQueueConfigSummary.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, QUEUE_ARN_FIELD, QUEUE_NAME_FIELD, PRIORITY_FIELD, DELAY_FIELD, CHANNEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String queueId;
    private final String queueArn;
    private final String queueName;
    private final Integer priority;
    private final Integer delay;
    private final String channel;

    private RoutingProfileQueueConfigSummary(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.queueArn = builder.queueArn;
        this.queueName = builder.queueName;
        this.priority = builder.priority;
        this.delay = builder.delay;
        this.channel = builder.channel;
    }

    public String queueId() {
        return this.queueId;
    }

    public String queueArn() {
        return this.queueArn;
    }

    public String queueName() {
        return this.queueName;
    }

    public Integer priority() {
        return this.priority;
    }

    public Integer delay() {
        return this.delay;
    }

    public Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public String channelAsString() {
        return this.channel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.delay());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileQueueConfigSummary)) {
            return false;
        }
        RoutingProfileQueueConfigSummary other = (RoutingProfileQueueConfigSummary)obj;
        return Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.queueArn(), other.queueArn()) && Objects.equals(this.queueName(), other.queueName()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.delay(), other.delay()) && Objects.equals(this.channelAsString(), other.channelAsString());
    }

    public String toString() {
        return ToString.builder((String)"RoutingProfileQueueConfigSummary").add("QueueId", (Object)this.queueId()).add("QueueArn", (Object)this.queueArn()).add("QueueName", (Object)this.queueName()).add("Priority", (Object)this.priority()).add("Delay", (Object)this.delay()).add("Channel", (Object)this.channelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "QueueArn": {
                return Optional.ofNullable(clazz.cast(this.queueArn()));
            }
            case "QueueName": {
                return Optional.ofNullable(clazz.cast(this.queueName()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Delay": {
                return Optional.ofNullable(clazz.cast(this.delay()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileQueueConfigSummary, T> g) {
        return obj -> g.apply((RoutingProfileQueueConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queueId;
        private String queueArn;
        private String queueName;
        private Integer priority;
        private Integer delay;
        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileQueueConfigSummary model) {
            this.queueId(model.queueId);
            this.queueArn(model.queueArn);
            this.queueName(model.queueName);
            this.priority(model.priority);
            this.delay(model.delay);
            this.channel(model.channel);
        }

        public final String getQueueId() {
            return this.queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        public final String getQueueArn() {
            return this.queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        public final String getQueueName() {
            return this.queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Integer getDelay() {
            return this.delay;
        }

        @Override
        public final Builder delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        public final void setDelay(Integer delay) {
            this.delay = delay;
        }

        public final String getChannel() {
            return this.channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        public RoutingProfileQueueConfigSummary build() {
            return new RoutingProfileQueueConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingProfileQueueConfigSummary> {
        public Builder queueId(String var1);

        public Builder queueArn(String var1);

        public Builder queueName(String var1);

        public Builder priority(Integer var1);

        public Builder delay(Integer var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);
    }
}

